﻿namespace _17_Demo_Sorting
{
    internal class Program
    {
        static void Main(string[] args)
        {
            #region Sayısal Bir Dizinin Bubble Sort Algoritması İle Sıralanması
            // Örnek sayısal veri kümesi: 4, 2, 3, 5, 1.
            // Örnek sayısal veri kümesi içindeki sayısal verileri
            // Bubble Sort Algoritması ile artan (küçükten büyüğe doğru) sıralama:

            decimal[] sayiKumesi = new decimal[] { 4, 2, 3, 5, 1 };

            decimal[] siralanmisSayiKumesi = BubbleSort(sayiKumesi);
            // BubbleSort methodunda params kullandığımızdan ihtiyaca göre methodu
            // BubbleSort(4, 2, 3, 5, 1) şeklinde istediğimiz kadar
            // parametre üzerinden de çağırabiliriz

            Console.WriteLine("Sayı kümesi:");
            foreach (decimal sayi in sayiKumesi)
            {
                Console.WriteLine(sayi);
            }
            // konsola alt alta 4, 2, 3, 5, 1 yazdırır

            Console.WriteLine("Bubble Sort ile artan sıralanmış sayı kümesi:");
            foreach (decimal siralanmisSayi in siralanmisSayiKumesi)
            {
                Console.WriteLine(siralanmisSayi);
            }
            // konsola alt alta 1, 2, 3, 4, 5 yazdırır
            #endregion



            #region Metinsel Bir Dizinin Bubble Sort Algoritması İle Sıralanması
            Console.WriteLine("\nMetin kümesi: Luna, Snoopy, angel, MAX, leo JR, lassie, lEo");

            string[] siralanmisMetinKumesi = BubbleSort("Luna", "Snoopy", "angel", "MAX", "leo JR", "lassie", "lEo");

            Console.WriteLine("Bubble Sort ile artan sıralanmış metin kümesi:");
            foreach (string siralanmisMetin in siralanmisMetinKumesi)
            {
                Console.WriteLine(siralanmisMetin);
            }
            // konsola alt alta angel, lassie, lEo, leo JR, Luna, MAX, Snoopy yazdırır
            #endregion



            #region Dizilerin Sort Methodu İle Sıralanması
            int[] sayiDizisi = new int[] { 1, 9, 2, 8, 3, 7, 4, 6, 5 };
            Console.Write("\nSayı dizisi: ");
            foreach (int sayiElemani in sayiDizisi) // konsola "Sayı dizisi: 1, 9, 2, 8, 3, 7, 4, 6, 5" yazdırır
            {
                Console.Write(sayiElemani + " ");
            }
            Array.Sort(sayiDizisi);
            Console.Write("\nSıralanmış sayı dizisi: ");
            foreach (int sayiElemani in sayiDizisi) // konsola "Sıralanmış sayı dizisi: 1, 2, 3, 4, 5, 6, 7, 8, 9" yazdırır
            {
                Console.Write(sayiElemani + " ");
            }

            string[] metinDizisi = { "a", "z", "B", "Y", "c" };
            Console.Write("\nMetin dizisi: ");
            foreach (string metinElemani in metinDizisi) // konsola "Metin dizisi: a, z, B, Y, c" yazdırır
            {
                Console.Write(metinElemani + " ");
            }
            Array.Sort(metinDizisi);
            Console.Write("\nSıralanmış metin dizisi: "); 
            foreach (string metinElemani in metinDizisi) // konsola "Sıralanmış metin dizisi: a, B, c, Y, z" yazdırır
            {
                Console.Write(metinElemani + " ");
            }
            #endregion
        }



        /// <summary>
        /// Bubble Sort Algoritması ile sayısal bir veri kümesi elemanlarının artan sıralanması.
        /// </summary>
        /// <param name="veriKumesi"></param>
        /// <returns>decimal[]</returns>
        static decimal[] BubbleSort(params decimal[] veriKumesi)
        {
            /*
            Örnek sayısal veri kümesi: 4, 2, 3, 5, 1.
            Örnek sayısal veri kümesi üzerinden algoritmanın açıklaması:
            Bubble Sort çalışmaya 4'ten başlar, 4 ile 2 karşılaştırılır ve 4 büyük olduğundan 2 ile yeri değiştirilir,
            sıra 3'e gelir, yeri değiştirilen 4 ile 3 karşılaştırılır ve 4 büyük olduğundan 3 ile yeri değiştirilir,
            sıra 5'e gelir, yeri değiştirilen 4 ile 5 karşılaştırılır ve 4 büyük olmadığından yer değiştirme işlemi yapılmaz,
            sıra 1'e gelir, 5 ile 1 karşılaştırılır ve 5 büyük olduğundan 1 ile yeri değiştirilir,
            sıra başa yani yeri değiştirilen 2'ye döner ve sıralama yukarıdaki şekilde devam eder.
            */

            decimal[] siralanmisVeriKumesi = veriKumesi.ToArray();
            // veriKumesi'ni siralanmisVeriKumesi'ne kopyalıyoruz ve sıralamayı siralanmisVeriKumesi
            // üzerinden yapıyoruz, eğer kopyalama işlemini yapmazsak parametre olarak gelen veriKumesi
            // referans olduğundan bu method içerisinde parametre üzerinde yapılan değişiklikler
            // methodun çağrıldığı yerdeki parametre olarak kullanılan değişkene yansır

            decimal gecici;
            bool degistirildiMi = true;

            for (int i = 1; i < siralanmisVeriKumesi.Length && degistirildiMi; i++)
            {
                degistirildiMi = false;
                for (int j = 0; j < siralanmisVeriKumesi.Length - 1; j++)
                {
                    if (siralanmisVeriKumesi[j] > siralanmisVeriKumesi[j + 1])
                    {
                        gecici = siralanmisVeriKumesi[j];
                        siralanmisVeriKumesi[j] = siralanmisVeriKumesi[j + 1];
                        siralanmisVeriKumesi[j + 1] = gecici;
                        degistirildiMi = true;
                    }
                }
            }

            return siralanmisVeriKumesi;
        }



        /// <summary>
        /// Bubble Sort Algoritması ile metinsel bir veri kümesi elemanlarının artan sıralanması.
        /// </summary>
        /// <param name="veriKumesi"></param>
        /// <returns>string[]</returns>
        static string[] BubbleSort(params string[] veriKumesi)
        {
            string[] siralanmisVeriKumesi = veriKumesi.ToArray();

            string gecici;
            bool degistirildiMi = true;

            for (int i = 1; i < siralanmisVeriKumesi.Length && degistirildiMi; i++)
            {
                degistirildiMi = false;
                for (int j = 0; j < siralanmisVeriKumesi.Length - 1; j++)
                {
                    // string.Compare methodu eğer parametre olarak gönderilen ilk string ikinci string'den sonra ise 0'dan büyük,
                    // önce ise 0'dan küçük, eşitse 0 döner, sırasıyla string'lerin karakterlerini karşılaştırır,
                    // StringComparison.CurrentCultureIgnoreCase parametresi ise bu methodda olduğu gibi bazı string methodlarında
                    // (Equals, Contains, vb.) büyük küçük harf duyarlılığını (case sensitivity) bilgisayarın bölgesel ayarına göre
                    // devre dışı bırakmak için kullanılabilir
                    if (string.Compare(siralanmisVeriKumesi[j], siralanmisVeriKumesi[j + 1], StringComparison.CurrentCultureIgnoreCase) > 0)
                    {
                        gecici = siralanmisVeriKumesi[j];
                        siralanmisVeriKumesi[j] = siralanmisVeriKumesi[j + 1];
                        siralanmisVeriKumesi[j + 1] = gecici;
                        degistirildiMi = true;
                    }
                }
            }

            return siralanmisVeriKumesi;
        }
    }
}