﻿namespace _14_String.Demos
{
    public class CumledeEsAnlamliKelimeleriDegistirme
    {
        public static void Calistir()
        {
            // herhangi bir ayraçla ayrılmış kelimelerin eş anlamlıları ile değiştirilmesi:
            string kelimeler = "macera,telefon,beyaz,rüya,siyah,anı,kitap";
            string[,] esAnlamliKelimeler = new string[,]
            {
                { "rüya", "düş" },
                { "beyaz", "ak" },
                { "anı", "hatıra" },
                { "macera", "serüven" },
                { "siyah", "kara" }
            };
            Console.WriteLine("Kelimeler: " + kelimeler);
            Console.WriteLine($"Eş anlamlı kelimeler: {EsAnlamliKelimeleriGetir(kelimeler, esAnlamliKelimeler)}");
        }

        public static string EsAnlamliKelimeleriGetir(string kelimeler, string[,] esAnlamliKelimeler, char ayrac = ',')
        {
            string sonuc = "";
            bool esAnlamliKelimeBulundu;
            string[] kelimeDizisi = kelimeler.Split(ayrac);
            foreach (string kelimeElemani in kelimeDizisi)
            {
                esAnlamliKelimeBulundu = false;
                for (int satir = 0; satir <= esAnlamliKelimeler.GetUpperBound(0); satir++)
                {
                    if (kelimeElemani == esAnlamliKelimeler[satir, 0])
                    {
                        esAnlamliKelimeBulundu = true;
                    }
                    if (esAnlamliKelimeBulundu)
                    {
                        sonuc += esAnlamliKelimeler[satir, 1] + ayrac;
                        break;
                    }
                }
                if (!esAnlamliKelimeBulundu)
                {
                    sonuc += kelimeElemani + ayrac;
                }
            }
            return sonuc.TrimEnd(ayrac);
        }
    }
}
