﻿namespace _06_IfConditional.Demos
{
    // Burak
    public class VucutKutleEndeksi
    {
        public static void Calistir()
        {
            BaslikYaz();
            double boy = Giris("Boy giriniz (m): ");
            double kilo = Giris("Kilo giriniz (kg): ");
            double endeks = EndeksHesapla(boy, kilo);
            Console.WriteLine($"Endeks: {endeks}");
            HesapSonucunuYazdir(endeks);
        }

        // summary'nin kullanılabileceği yerlerden biri methodlardır. Methodun çağrıldığı yerde method ismi yazılırken veya yazıldıktan sonra üzerine
        // fare ile gelindiğinde summary içeriği görülebilir. Amaç method çağrılırken açıklamasını görebilmektir.
        /// <summary>
        /// Gönderilen boy ve kiloya göre endeks hesaplar.
        /// </summary>
        /// <param name="boy"></param>
        /// <param name="kilo"></param>
        /// <returns>double</returns>
        public static double EndeksHesapla(double boy, double kilo)
        {
            double endeks = kilo / (boy * boy);
            return endeks;
        }

        public static void HesapSonucunuYazdir(double endeks)
        {
            Console.Write("Vücut Kütle Endeksiniz: ");
            if (endeks < 18)
                Console.WriteLine("Zayıf");
            else if (endeks >= 18 && endeks < 25)
                Console.WriteLine("Normal");
            else if (endeks >= 25 && endeks < 30)
                Console.WriteLine("Kilolu");
            else if (endeks >= 30 && endeks < 35)
                Console.WriteLine("Obez");
            else
                Console.WriteLine("Ultra Obez");
        }

        public static void BaslikYaz()
        {
            Console.WriteLine("*** Vücut Kütle Endeksi Hesaplama ***");
        }

        public static double Giris(string mesaj)
        {
            double giris;
            Console.Write(mesaj);
            giris = Convert.ToDouble(Console.ReadLine());
            return giris;
        }
    }
}
