﻿namespace _12_Arrays.Demos
{
    public class EnBuyukVeKucukSayiBulma
    {
        public static void Calistir()
        {
            /* Algoritma örnek 1: Bir dizideki en büyük ve en küçük tam sayı bulma algoritması:
               1. başla
               2. kullanıcıya kaç tam sayı gireceği sorulur
               3. kullanıcıya girdiği tam sayı adedi kadar tam sayı sorulur
               4. kullanıcının girdiği tam sayılar bir methoda en büyük veya en küçük sayı mı bulunacağı 
                  parametresi ile birlikte gönderilir
               5. method içerisinde kullanıcının gönderdiği parametreler üzerinden en büyük veya 
                  en küçük sayı bulunarak dönülür
               6. methoddan dönülen sayı en büyük veya en küçük şeklinde konsola yazdırılır
               7. bitiş
            */
            Console.Write("Girilecek tam sayı adedi: ");
            int adet = Convert.ToInt32(Console.ReadLine());
            int[] sayilar = new int[adet];
            for (int i = 0; i < sayilar.Length; i++)
            {
                Console.Write($"{i + 1}. tam sayı: ");
                sayilar[i] = int.Parse(Console.ReadLine());
            }
            int sonuc = EnBuyukVeyaEnKucukBul1(sayilar);
            Console.WriteLine("En büyük tam sayı: " + sonuc);
            sonuc = EnBuyukVeyaEnKucukBul1(sayilar, false);
            Console.WriteLine("En küçük tam sayı: " + sonuc);
			sonuc = EnBuyukVeyaEnKucukBul2(sayilar);
			Console.WriteLine("En büyük tam sayı: " + sonuc);
			sonuc = EnBuyukVeyaEnKucukBul2(sayilar, false);
			Console.WriteLine("En küçük tam sayı: " + sonuc);
		}

        public static int EnBuyukVeyaEnKucukBul1(int[] sayilar, bool enBuyukMu = true)
        {
            int enBuyukVeyaEnKucukSayi = sayilar[0];
            for (int i = 1; i < sayilar.Length; i++)
            {
                if (enBuyukMu)
                {
                    if (sayilar[i] > enBuyukVeyaEnKucukSayi)
                        enBuyukVeyaEnKucukSayi = sayilar[i];
                }
                else
                {
                    if (sayilar[i] < enBuyukVeyaEnKucukSayi)
                        enBuyukVeyaEnKucukSayi = sayilar[i];
                }
            }
            return enBuyukVeyaEnKucukSayi;
        }

		public static int EnBuyukVeyaEnKucukBul2(int[] sayilar, bool enBuyukMu = true)
		{
			return enBuyukMu ? sayilar.Max() : sayilar.Min();
		}
	}
}
