﻿namespace _14_String.Demos
{
    public class SesliSessizHarfBulma
    {
        public static void Calistir()
        {
            Console.Write("Kelime (çıkış için 0): ");
            string kelime = Console.ReadLine().ToLower();
            string sesliSessiz;
            string sonuc;
            string[] sesliler = new string[]
            {
                "a", "e", "ı", "i", "o", "ö", "u", "ü"
            };
            while (kelime != "0")
            {
                Console.Write("Sesli harf (1), sessiz harf (2): ");
                sesliSessiz = Console.ReadLine();
                if (sesliSessiz == "1")
                {
                    sonuc = "Sesli harfler 1: " + SesliBul1(kelime, sesliler);
                    Console.WriteLine(sonuc);
                    sonuc = "Sesli harfler 2: " + SesliBul2(kelime, sesliler);
                    Console.WriteLine(sonuc);
                    sonuc = "Sesli harfler 3: " + SesliSessizBul3(kelime, sesliler, true);
                    Console.WriteLine(sonuc);
                    sonuc = "Sesli harfler 4: " + SesliSessizBul4(kelime, sesliler, true);
                    Console.WriteLine(sonuc);
                }
                else
                {
                    sonuc = "Sessiz harfler 1: " + SessizBul1(kelime, sesliler);
                    Console.WriteLine(sonuc);
                    sonuc = "Sessiz harfler 2: " + SessizBul2(kelime, sesliler);
                    Console.WriteLine(sonuc);
                    sonuc = "Sessiz harfler 3: " + SesliSessizBul3(kelime, sesliler, false);
                    Console.WriteLine(sonuc);
                    sonuc = "Sessiz harfler 4: " + SesliSessizBul4(kelime, sesliler, false);
                    Console.WriteLine(sonuc);
                }
                Console.Write("Kelime (çıkış için 0): ");
                kelime = Console.ReadLine().ToLower();
            }
        }

        public static string SessizBul1(string kelime, string[] sesliler)
        {
            string sonuc = "";
            bool sessizMi;
            int sessizSayisi = 0;
            foreach (char harf in kelime)
            {
                sessizMi = true;
                foreach (string sesli in sesliler)
                {
                    if (harf.ToString() == sesli)
                    {
                        sessizMi = false;
                        break;
                    }
                }
                if (sessizMi)
                {
                    sessizSayisi++;
                    if (!sonuc.Contains(harf))
                        sonuc += harf + " (" + KelimedeHarfleriSay(harf, kelime) + "), ";
                }
            }
            return sonuc.Trim(',', ' ') + ", toplam sessiz: " + sessizSayisi;
        }

        public static string SessizBul2(string kelime, string[] sesliler)
        {
            string sonuc = "";
            foreach (char harf in kelime)
            {
                if (!sesliler.Contains(harf.ToString()) && !sonuc.Contains(harf))
                    sonuc += harf;
            }
            return sonuc;
        }

        public static string SesliBul1(string kelime, string[] sesliler)
        {
            string sonuc = "";
            bool sesliMi;
            int sesliSayisi = 0;
            foreach (char harf in kelime)
            {
                sesliMi = false;
                foreach (string sesli in sesliler)
                {
                    if (harf.ToString() == sesli)
                    {
                        sesliMi = true;
                        break;
                    }
                }
                if (sesliMi)
                {
                    sesliSayisi++;
                    if (!sonuc.Contains(harf))
                        sonuc += harf + " (" + KelimedeHarfleriSay(harf, kelime) + ") ";
                }
            }
            return sonuc.Trim(',', ' ') + ", toplam sesli: " + sesliSayisi;
        }

        public static string SesliBul2(string kelime, string[] sesliler)
        {
            string sonuc = "";
            foreach (char harf in kelime)
            {
                if (sesliler.Contains(harf.ToString()) && !sonuc.Contains(harf))
                    sonuc += harf;
            }
            return sonuc;
        }

        public static string SesliSessizBul3(string kelime, string[] sesliler, bool sesliMiBulunacak)
        {
            string sonuc = "";
            bool sesliMi; // flag
            foreach (char harf in kelime)
            {
                sesliMi = false;
                foreach (string sesli in sesliler)
                {
                    if (harf.ToString() == sesli)
                    {
                        sesliMi = true;
                        break;
                    }
                }
                if (sesliMi && sesliMiBulunacak && !sonuc.Contains(harf))
                {
                    sonuc += harf;
                }
                else if (!sesliMi && !sesliMiBulunacak && !sonuc.Contains(harf))
                {
                    sonuc += harf;
                }
            }
            return sonuc;
        }

        public static string SesliSessizBul4(string kelime, string[] sesliler, bool sesliMiBulunacak)
        {
            string sonuc = "";
            foreach (char harf in kelime)
            {
                if (sesliler.Contains(harf.ToString()) && sesliMiBulunacak && !sonuc.Contains(harf))
                    sonuc += harf;
                else if (!sesliler.Contains(harf.ToString()) && !sesliMiBulunacak && !sonuc.Contains(harf))
                    sonuc += harf;
            }
            return sonuc;
        }

        public static int KelimedeHarfleriSay(char sayilacakHarf, string kelime)
        {
            int sayi = 0;
            foreach (char harf in kelime)
            {
                if (sayilacakHarf == harf)
                    sayi++;
            }
            return sayi;
        }
    }
}
