﻿namespace _14_String.Demos
{
    public class TurkceHarfleriIngilizceyeDonusturme
    {
        public static void Calistir()
        {
            Console.Write("Türkçe cümle giriniz: ");
            string turkceCumle = Console.ReadLine();
            string ingilizceCumle;
            Console.WriteLine("Türkçe cümle: " + turkceCumle);

            ingilizceCumle = Donustur1(turkceCumle);
            Console.WriteLine("İngilizce cümle 1: " + ingilizceCumle);

            ingilizceCumle = Donustur2(turkceCumle);
            Console.WriteLine("İngilizce cümle 2: " + ingilizceCumle);
        }

        // 1. çözüm methodu:
        public static string Donustur1(string turkceCumle)
        {
            string sonuc = "";
            string[,] turkceIngilizceHarfler = new string[12, 2]
            {
                { "Ö", "O" },
                { "Ç", "C" },
                { "Ş", "S" },
                { "İ", "I" },
                { "Ğ", "G" },
                { "Ü", "U" },
                { "ö", "o" },
                { "ç", "c" },
                { "ş", "s" },
                { "ı", "i" },
                { "ğ", "g" },
                { "ü", "u" } 
            };
            bool turkceHarfBulundu;
            foreach (char turkceCumleHarfi in turkceCumle)
            {
                turkceHarfBulundu = false;
                for (int satir = 0; satir <= turkceIngilizceHarfler.GetUpperBound(0); satir++)
                {
                    if (turkceIngilizceHarfler[satir, 0] == turkceCumleHarfi.ToString())
                    {
                        turkceHarfBulundu = true;
                    }
                    if (turkceHarfBulundu)
                    {
                        sonuc += turkceIngilizceHarfler[satir, 1];
                        break;
                    }
                }
                if (!turkceHarfBulundu)
                {
                    sonuc += turkceCumleHarfi;
                }
            }
            return sonuc;
        }

        // 2. daha güzel çözüm methodu:
        public static string Donustur2(string turkceCumle)
        {
            // String class'ının Replace methodu üzerinden bulunan Türkçe karakterler kolaylıkla
            // İngilizce karakter karşılıklarıyla değiştirilebilir.
            return turkceCumle.Replace('Ö', 'O')
                .Replace('Ç', 'C')
                .Replace('Ş', 'S')
                .Replace('İ', 'I')
                .Replace('Ğ', 'G')
                .Replace('Ü', 'U')
                .Replace('ö', 'o')
                .Replace('ç', 'c')
                .Replace('ş', 's')
                .Replace('ı', 'i')
                .Replace('ğ', 'g')
                .Replace('ü', 'u');
        }
    }
}
