﻿// Class Properties (Class'larda Özellikler)

using _02_ClassProperties.Demos.Bilgisayarlar;

namespace _02_ClassProperties
{
    internal class Program
    {
        // class'larda public olmayan alanlar oluşturup getter ve setter methodları yazmak yerine getter ve setter'ları içeren property'leri (özellikleri) kullanmak daha uygundur.
        // bu örnekteki Araba class'ına başka dosyada olmasına rağmen aynı namespace (_02_ClassProperties) altında olduğu için direkt olarak ulaşılabilir.

        // Yeni bir class oluşturduğumuzda default olarak gelen class template'ına (şablon) public eklemek için:
        // C:\Program Files\Microsoft Visual Studio\2022\Community\Common7\IDE\ItemTemplates\CSharp\Code\1033\Class
        // klasörünü açıp Class.cs dosyasını edit'liyerek "class" başına "public" ekliyoruz.



        static void Main(string[] args)
        {
            Araba araba1 = new Araba(); // önce class'tan obje oluşturulup daha sonra özellikleri set edilebilir.
            araba1.Marka = "Mini"; // property'deki set bloğu çalışır.
            araba1.Model = "Cooper S";
            //araba1.Turu = Turler.Binek; // Araba class'ında Turu özelliğinin ilk değer ataması olduğundan burada atama yapmaya gerek yoktur.
            araba1.TrafigeCikisTarihi = DateTime.Parse("02.12.2022");
            araba1.BeygirGucu = 184;
            araba1.KapiSayisi = 3;
            araba1.MotorHacmi = 1600;
            string araba1Text = "";
            araba1Text += $"Marka: {araba1.Marka}\n"; // property'deki get bloğu çalışır
            araba1Text += $"Model: {araba1.Model}\n";
            araba1Text += $"Tür: {araba1.Turu} ({(int)araba1.Turu})\n";
            araba1Text += $"Trafiğe Çıkış Tarihi: {araba1.TrafigeCikisTarihi.ToShortDateString()}\n";
            araba1Text += $"Beygir Gücü: {araba1.BeygirGucu} Hp\n";
            araba1Text += $"Kapı Sayısı: {araba1.KapiSayisi} kapı\n";
            araba1Text += $"Motor Hacmi: {araba1.MotorHacmi} cm3";
            Console.WriteLine(araba1Text);



            Araba araba2 = new Araba() // veya class'tan obje oluşturulurken özellikleri set edilebilir.
            {
                Marka = "Fiat",
                Model = "Doblo",
                Turu = ArabaTipi.Ticari,
                TrafigeCikisTarihi = new DateTime(2023, 1, 1),
                BeygirGucu = 68,
                KapiSayisi = 5,
                MotorHacmi = 1300
            };
            Console.WriteLine($"Marka: {araba2.Marka}\nModel: {araba2.Model}\nTür: {araba2.Turu}\nTrafiğe Çıkış Tarihi: {araba2.TrafigeCikisTarihi.ToShortDateString()}\n" +
                $"Beygir Gücü: {araba2.BeygirGucu} Hp\nKapı Sayısı: {araba2.KapiSayisi} kapı\nMotor Hacmi: {araba2.MotorHacmi} cm3");



            #region Demos
            BilgisayarDemo.Calistir();
            #endregion
        }
    }
}