﻿// Encapsulation (Kapsülleme)

using _03_Encapsulation.Demos.Barbut;
using _03_Encapsulation.Demos.Dizi;

namespace _03_Encapsulation
{
    internal class Program
    {
        // Encapsulation: class'ların field'lerine (alanlarına) public olarak ulaşmak yerine field'ler için set ve get methodları üzerinden kapsülleyerek yönetmektir,
        // public olan property kullanımı ile encapsulation gerçekleştirilmiş olur. 
        // Eğer istenirse alanların set veya get davranışlarında veya özelliklerin setter veya getter'larında koda müdahele edilerek özelliştirme yapılabilir. 
        // Örneğin bir cüzdan ortada bırakılıp herkesin ulaşabilmesi sağlanmamalıdır (public field),
        // bunun yerine cüzdana sanki izin alınıyormuş gibi setter ve getter'larla ulaşılmalıdır.



        static void Main(string[] args)
        {
            // Musteri class'ının namespace'i, Program class'ının namespace'inden farklı olduğundan ya Musteri class'ının namespace'i ile birlikte kullanılabilir
            // ya da using ile en yukarıya Musteri class'ının namespace'i eklenir.

            //_03_Encapsulation.Models.Musteri musteri1 = new _03_Encapsulation.Models.Musteri()  // 1. yöntem
            //Models.Musteri musteri1 = new Models.Musteri()  // 2. yöntem
            Musteri musteri1 = new Musteri() // 3. yöntem, using en yukarıya eklenir
            {
                Adi = "Çağıl",
                Soyadi = "Alsaç",
                Yasi = 42,
                CepTelefonu = "0 532 111 22 33",
                Adresi = "Çankaya, Ankara, Türkiye",
                KrediKartiNumarasi = "1234 5678 9012 3456",
                KadinMi = false
            };
            // Class üzerinden obje new'lenirken (initialization) class özellikleri set edilebilir.

            // Ya da class üzerinden obje new'lendikten sonra (initialization) class özellikleri set edilebilir.
            Musteri musteri2 = new Musteri();
            musteri2.Adi = "Luna";
            musteri2.Soyadi = "Alsaç";
            musteri2.Yasi = 1;
            musteri2.CepTelefonu = "0 532 999 88 77";
            musteri2.Adresi = "Çankaya, Ankara, Türkiye";
            musteri2.KrediKartiNumarasi = "9876 5432 1098 7654";
            musteri2.KadinMi = true;

            // 1. müşterinin ekrana yazdırılması:
            Console.WriteLine("Müşteri Bilgileri\nAdı: " + musteri1.Adi + "\nSoyadı: " + musteri1.Soyadi + "\nYaşı: " + musteri1.Yasi + 
                "\nCep Telefonu: " + musteri1.CepTelefonu + "\nAdresi: " + musteri1.Adresi +
                "\nCinsiyeti: " + musteri1.Cinsiyeti + "\nKart No: " + musteri1.KrediKartiNumarasi); // konsola Cinsiyeti: Erkek, Kart No: **** **** **** 3456 yazdıracak
            Console.WriteLine($"Müşteri: {musteri1.UnvanliTamAdi}"); // konsola "Bay Çağıl Alsaç" yazdıracak

            Console.WriteLine();

            // 2. müşterinin ekrana yazdırılması:
            Console.WriteLine($"Müşteri Bilgileri:\nMüşteri: {musteri2.UnvanliTamAdi}\nYaşı: {musteri2.Yasi}" +
                $"\nCep Telefonu: {musteri2.CepTelefonu}\nAdresi: {musteri2.Adresi}" +
                $"\nKart No: {musteri2.KrediKartiNumarasi}"); // konsola Kart No: **** **** **** 7654 yazdıracak

            Console.WriteLine();



            #region Demos
            DiziDemo.Calistir();
            Console.WriteLine();
            BarbutDemo.Calistir();
            #endregion
        }
    }
}