﻿using System.Globalization;

namespace _05_IDisposableAndFinalizers
{
    internal class Program
    {
        static void Main(string[] args)
        {
            #region Finalizer
            // 1) kategorimizi oluşturuyoruz
            Kategori kategori = new Kategori()
            {
                Id = 1,
                Adi = "Bilgisayar",
                Aciklamasi = "Masaüstü ve dizüstü bilgisayarlar"
            };

            // 2) kategorimizi ekrana yazdırıyoruz
            Console.WriteLine($"KATEGORİ\nAdı: {kategori.Adi}\nAçıklaması: {kategori.Aciklamasi}");
            #endregion



            Console.WriteLine();



            #region IDisposable
            // 1) ürünümüzü oluşturuyoruz
            Urun urun1 = new Urun(1, "ASUS ROG Laptop", 50000, 100);

            // 2) ürünümüzü ekrana C2 (currency, parabirimi ve ondalıktan sonra iki hane) ile Türkçe bölgesel ayarına göre yazdırıyoruz
            Console.WriteLine($"ÜRÜN\nId: {urun1.Id}\nAdı: \"{urun1.Adi}\"\n" +
                $"Birim Fiyatı: {urun1.BirimFiyati.ToString("C2", new CultureInfo("tr-TR"))}\nStok Miktarı: {urun1.StokMiktari} adet");

            // 3) ürünümüz ile işimiz bittiği için çöpe atıyoruz (dispose ediyoruz), her zaman IDisposable implemente edilip Dispose methodu kullanılması zorunlu değildir
            urun1.Dispose();



            // 1) ürünümüzü oluşturuyoruz
            Urun urun2 = new Urun()
            {
                Id = 2,
                Adi = "HP Omen Laptop",
                BirimFiyati = 60000,
                StokMiktari = 50
            };

            // 2) ürünümüzü ekrana C2 (currency, parabirimi ve ondalıktan sonra iki hane) ile İngilizce bölgesel ayarına göre yazdırıyoruz
            Console.WriteLine($"PRODUCT\nId: {urun2.Id}\nName: \"{urun2.Adi}\"\n" +
                $"Unit Price: {urun2.BirimFiyati.ToString("C2", new CultureInfo("en-US"))}\nStock Amount: {urun2.StokMiktari} unit(s)");

            // 3) ürünümüz ile işimiz bittiği için çöpe atıyoruz (dispose ediyoruz), her zaman IDisposable implemente edilip Dispose methodu kullanılması zorunlu değildir
            urun2.Dispose();

            // Objeyi dispose etmek yerine referans değişkenini null atamak (örneğin urun2 = null;) doğru bir yöntem değildir.
            // Bu işlem objeyi hafızadan temizlemez, sadece referans değişkeni ile obje arasındaki bağlantıyı kaldırır.
            // Artık bu referans değişkeni üzerinden işlem yapıldığında Null Reference Exception hatası fırlatılacaktır.
            #endregion
        }
    }
}