﻿namespace _08_InterfaceSegregation._1_Arac
{
    class Araba : IArac, IDireksiyon, IKasaTipi // Araba class'ı IArac, IDireksiyon ve IKasaTipi interface'lerini implemente eder
    {
        // özellikler (properties)
        public int TekerlekSayisi { get; set; } // IArac'dan implemente edildi
        public YakitTipiEnum YakitTipi { get; set; } // IArac'dan implemente edildi
        public string Marka { get; set; } // IArac'dan implemente edildi
        public string Model { get; set; } // IArac'dan implemente edildi
        public int BeygirGucu { get; set; } // IArac'dan implemente edildi
        public int MotorHacmi { get; set; } // IArac'dan implemente edildi
        public bool DireksiyonSoldaMi { get; set; } // IDireksiyon'dan implemente edildi
        public KasaTipiEnum KasaTipi { get; set; } // IKasaTipi'nden implemente edildi



        // methodlar (behaviors)
        public string AracBilgileriniGetir(string satirSonu = " ") // IArac'dan implemente edildi
        {
            string arac = "";
            arac += "Tekerlek Sayısı: " + TekerlekSayisi + satirSonu;
            arac += "Direksiyon Yeri: " + (DireksiyonSoldaMi ? "Solda" : "Sağda") + satirSonu;
            arac += "Yakıt Tipi: " + YakitTipi + satirSonu;
            arac += "Marka: " + Marka + satirSonu;
            arac += "Model: " + Model + satirSonu;
            arac += "Kasa Tipi: " + KasaTipi + satirSonu;
            arac += "Beygir Gücü: " + BeygirGucu + satirSonu;
            arac += "Motor Hacmi: " + MotorHacmi;
            return arac;
        }
    }
}
