﻿using _09_Inheritance.Demos.Elektronik.Models;
using System.Globalization;

namespace _09_Inheritance.Demos.Elektronik
{
    public class ElektronikDemo
    {
        public static void Calistir()
        {
            #region Bilgisayar
            // Bilgisayar tipinde bilgisayar referans değişkeni tanımlanması ve bu değişken üzerinden Bilgisayar objesi oluşturulması,
            // genelde veri taşıyan modellerde referans değişkeninin tipi base tip (ElektronikEsya) değil sub tip (Bilgisayar) kullanılır
            Bilgisayar bilgisayar = new Bilgisayar() // obje oluşturulurken özelliklerinin atanması
            {
                Marka = "ASUS", // ElektronikEsya class'ından miras alınan özellik
                Model = "ROG", // ElektronikEsya class'ından miras alınan özellik
                SeriNo = "AR123", // ElektronikEsya class'ından miras alınan özellik

                UretimTarihi = DateTime.Parse("16.03.2023 12:44:55", new CultureInfo("tr-TR")), // ElektronikEsya class'ından miras alınan özellik
                //UretimTarihi = new DateTime(2023, 3, 16, 12, 44, 55) de yazılabilir, 

                BilgisayarTipi = BilgisayarTipi.Dizüstü, // Bilgisayar class'ı özelliği
                IslemciTipi = IslemciTipi.i7, // Bilgisayar class'ı özelliği
                Hafiza = 16, // Bilgisayar class'ı özelliği
                EkranBoyutu = 27, // Bilgisayar class'ı özelliği
                SuSogutmaliMi = true // Bilgisayar class'ı özelliği
            };

            // bilgisayarın ekrana yazdırılması
            string bilgisayarBilgisi = $"Bilgisayar:\n" +
                $"Marka: {bilgisayar.Marka}\n" +
                $"Model: {bilgisayar.Model}\n" +
                $"Seri No: {bilgisayar.SeriNo}\n" +
                $"Üretim Tarihi: {bilgisayar.UretimTarihi.ToString("dd.MM.yyyy HH:mm:ss")}\n" +
                $"Bilgisayar Tipi: {bilgisayar.BilgisayarTipi} ({(int)bilgisayar.BilgisayarTipi})\n" +
                $"İşlemci Tipi: {bilgisayar.IslemciTipi} ({(int)bilgisayar.IslemciTipi})\n" +
                $"Hafıza: {bilgisayar.Hafiza} GB\n" +
                $"Ekran Boyutu: {bilgisayar.EkranBoyutu} inç\n" +
                $"Su Soğutma: {bilgisayar.SuSogutmali} ({bilgisayar.SuSogutmaliMi})\n" +
                $"Kategori: {bilgisayar.Kategori}";

            Console.WriteLine(bilgisayarBilgisi);

            Console.WriteLine();
            #endregion



            #region Ev Sinema Sistemi
            // EvSinemaSistemi tipinde evSinemaSistemi referans değişkeni tanımlanması ve bu değişken üzerinden EvSinemaSistemi objesi oluşturulması,
            // genelde veri taşıyan modellerde referans değişkeninin tipi base tip (ElektronikEsya) değil sub tip (EvSinemaSistemi) kullanılır
            EvSinemaSistemi evSinemaSistemi = new EvSinemaSistemi(); // önce obje oluşturulması sonra obje özelliklerinin atanması

            evSinemaSistemi.Marka = "Bose"; // ElektronikEsya class'ından miras alınan özellik
            evSinemaSistemi.Model = "Lifestyle 650"; // ElektronikEsya class'ından miras alınan özellik
            evSinemaSistemi.SeriNo = "BL650"; // ElektronikEsya class'ından miras alınan özellik
            evSinemaSistemi.UretimTarihi = DateTime.Parse("27.01.2023 16:54:06", new CultureInfo("tr-TR")); // ElektronikEsya class'ından miras alınan özellik

            evSinemaSistemi.HoparlorSayisi = 6; // EvSinemaSistemi class'ı özelliği
            evSinemaSistemi.Guc = 180; // EvSinemaSistemi class'ı özelliği

            // ev sinema sisteminin ekrana yazdırılması
            string evSinemaSistemiBilgisi = $"Ev Sinema Sistemi:\n" +
                $"Marka: {evSinemaSistemi.Marka}\n" +
                $"Model: {evSinemaSistemi.Model}\n" +
                $"Seri No: {evSinemaSistemi.SeriNo}\n" +
                $"Üretim Tarihi: {evSinemaSistemi.UretimTarihi.ToString("dd.MM.yyyy HH:mm:ss")}\n" +
                $"Hoparlör Sayısı: {evSinemaSistemi.HoparlorSayisi} adet\n" +
                $"Güç: {evSinemaSistemi.Guc} Watt";

            Console.WriteLine(evSinemaSistemiBilgisi);
            #endregion
        }
    }
}
