﻿using _09_Inheritance.Demos.Elektronik.Models.Bases;

namespace _09_Inheritance.Demos.Elektronik.Models
{
    class Bilgisayar : ElektronikEsya // sub (child) concrete (somut) class,
                                             // is-a relationship: bilgisayar bir elektronik eşyadır
    {
        #region Properties
        public BilgisayarTipi BilgisayarTipi { get; set; }
        public IslemciTipi IslemciTipi { get; set; }
        public short Hafiza { get; set; } // GB
        public double EkranBoyutu { get; set; } // inç
        public bool SuSogutmaliMi { get; set; }

        public string SuSogutmali => SuSogutmaliMi ? "Var" : "Yok"; // readonly property
        public string Kategori // readonly property
        { 
            get
            {
                // if'in içerisine noktalı virgülle biten tek kod bloğu yazılırsa süslü parantez kullanmaya gerek yoktur,
                // eğer işlemci i7 veya i9 ise ve hafıza da 16 GB'den büyük veya eşitse
                if ((IslemciTipi == IslemciTipi.i7 || IslemciTipi == IslemciTipi.i9) && Hafiza >= 16)
                    return "Oyun Bilgisayarı"; // oyun bilgisayarı dön
                return "İş Bilgisayarı"; // eğer işlemci i7 değilse ve i9 değilse veya hafıza 16'dan küçükse iş bilgisayarı dön
            }
        }
        #endregion
    }
}
