﻿using System.Globalization;

namespace _11_AbstractClasses._1_ProductAndStore
{
    public class ProductAndStoreDemo
    {
        public static void Calistir()
        {
            //RecordBase record = new RecordBase(); // record objesi new'lenemez çünkü tipi olan RecordBase bir abstract (soyut) class'tır

            Product product = new Product() // product (ürün) new'lenebilir çünkü Product bir concrete (somut) class'tır
            {
                Id = 1, // RecordBase class'ından miras alınan özellik
                Guid = Guid.NewGuid().ToString(), // RecordBase class'ından miras alınan özellik,
                                                  // oluşturulacak guid örneği: b49336bf-1048-460d-84ca-7166c9f151b6,
                                                  // uygulama her çalıştığında tekil yeni bir guid oluşacaktır

                Name = "ASUS ROG", // Product class'ı özelliği
                UnitPrice = 2500, // Product class'ı özelliği
                StockAmount = 25 // Product class'ı özelliği
            };

            Console.WriteLine($"Product:\n" +
                $"Id: {product.Id}\n" +
                $"Guid: {product.Guid}\n" +
                $"Name: {product.Name}\n" +
                $"Stock Amount: {product.StockAmount}\n" +
                $"Unit Price: {product.UnitPrice.ToString("C2", new CultureInfo("en-US"))}"); // C2: en-US (A.B.D. İngilizce) olarak 2 ondalık haneli currency (para birimi) formatı

            Console.WriteLine();



            Store store = new Store() // store (mağaza) new'lenebilir çünkü Store bir concrete (somut) class'tır
            {
                Id = 1, // RecordBase class'ından miras alınan özellik
                Guid = Guid.NewGuid().ToString(), // RecordBase class'ından miras alınan özellik
                Name = "Best Buy", // Store class'ı özelliği
                Country = "United States", // Store class'ı özelliği
                City = "Phoenix" // Store class'ı özelliği
            };

            Console.WriteLine("Store:\n" +
                "Id: " + store.Id + "\n" +
                "Guid: " + store.Guid + "\n" +
                "Name: " + store.Name + "\n" +
                "Location: " + store.City + " (" + store.Country + ")");
        }
    }
}
