﻿using _11_AbstractClasses._2_Dersler.Bases;

namespace _11_AbstractClasses._2_Dersler
{
    class MuzikDersi : DersBase // MuzikDersi bir DersBase'dir (is-a relationship).
                                // DersBase içerisindeki KodGetir soyut method tanımı ezilerek implemente edilmelidir.
                                // MaksimumNotGetir ve DersNotuHesapla sanal methodları ise isteğe göre
                                // ezilerek davranışları değiştirilebilir.
    {
        #region Behaviors
        /// <summary>
        /// Müzik dersleri için MZK ön eki üzerinden atanan Id ile ders kodunu döner.
        /// </summary>
        /// <returns>string</returns>
        public override string KodGetir() => "MZK-" + Id;



        /// <summary>
        /// Müzik dersleri için maksimum notu 10 olarak döner.
        /// </summary>
        /// <returns>byte</returns>
        public override byte MaksimumNotGetir() => 10;



        // Müzik dersleri için iki sınav olacağından DersNotuHesapla() methodunu ezmeyip base sınıfındakini kullanacağız.
        // Aşağıdaki şekilde de method ezilip base sınıfındaki method çağrılabilir ancak bunu yapmaya gerek yoktur çünkü
        // iki işlem sonucunda da base sınıfındaki methodu kullanmış oluyoruz.
        //public override double DersNotuHesapla() => base.DersNotuHesapla();
        #endregion
    }
}
