﻿using _12_InterfacesVsAbstractClasses._1_InterfaceOrnegi.Bases;
using System.Text;

namespace _12_InterfacesVsAbstractClasses._1_InterfaceOrnegi
{
    /// <summary>
    /// Öğrenciler için metinsel (.txt uzantılı) dosya işlemlerini gerçekleştiren somut (concrete) sınıf.
    /// </summary>
    class MetinselOgrenciDosya : IOgrenciDosya // MetinselOgrenciDosya sınıfı IOgrenciDosya interface'ini implemente eder,
                                               // MetinselOgrenciDosya bir IOgrenciDosya'dır şeklinde de okunabilir
    {
        #region Özellikler
        public string DosyaYolu { get; set; } // interface'i implemente ettiğimizden DosyaYolu özelliği oluşturuldu
        #endregion



        #region Methodlar
        /// <summary>
        /// Metin dosyası içeriğini sayiEkle parametresine göre string olarak dönen method.
        /// </summary>
        /// <param name="sayiEkle"></param>
        /// <returns>string</returns>
        public string OgrencileriGetir(bool sayiEkle) // interface'i implemente ettiğimizden method tanımı üzerinden implemente etmemiz için method oluşturuldu
        {
            string ogrenciler = ""; // dosyadan okuyacağımız öğrenci bilgilerini atayacağımız ve ilk olarak da içinde hiç bir karakter olmayan string değeri ataması yaptığımız değişken

            if (sayiEkle) // eğer sayiEkle true ise dosyadan okuduğumuz öğrenci bilgilerinin başına artacak şekilde sayı ekleyeceğiz
            {
                string[] ogrenciDizisi = File.ReadAllLines(DosyaYolu, Encoding.UTF8); // önce dizi olarak öğrenci bilgilerini alıyoruz,
                                                                                      // File class'ının ReadAllLines methodu dosya içeriğindeki her bir satır üzerinden string[] döner,
                                                                                      // Encoding.UTF8 parametresi yazılmasa da olur ancak eğer metinsel dosya içeriğinde Türkçe karakterler
                                                                                      // (utf-8 karakter kümesi) varsa karakterlerde sorun yaşanmaması için kullanılması iyi olur

                for (int i = 0; i < ogrenciDizisi.Length; i++) // sonra dizideki her bir öğrenci bilgisini turlayarak öğrenci bilgisi başına birer birer artacak şekilde sayı ekliyoruz
                {
                    ogrenciler += i + 1 + ") " + ogrenciDizisi[i] + "\n";
                }

                ogrenciler = ogrenciler.TrimEnd('\n'); // döngü sonucunda oluşan ogrenciler'deki en son \n (new line) escape character'ini (escape sequence) temizliyoruz
            }
            else // eğer sayiEkle false ise dosyadan okuduğumuz öğrenci bilgilerini ekstra hiç bir işlem yapmadan döneceğiz
            {
                ogrenciler = File.ReadAllText(DosyaYolu, Encoding.UTF8); // File class'ının ReadAllText methodu dosya içeriğini string olarak döner
            }

            return ogrenciler; // öğrenci bilgilerini dönüyoruz
        }



        /// <summary>
        /// String olarak gönderilen ogrenci parametresini dosya sonuna ekleyen (append) method.
        /// </summary>
        /// <param name="ogrenci"></param>
        public void OgrenciEkle(string ogrenci) // interface'i implemente ettiğimizden method tanımı üzerinden implemente etmemiz için method oluşturuldu
        {
            File.AppendAllText(DosyaYolu, "\n" + ogrenci, Encoding.UTF8); // File class'ının AppentAllText methodu gönderilen string tipindeki veriyi dosyanın sonuna ekler,
                                                                          // eğer WriteAllText methodu kullanılsaydı gönderilen veri mevcut verinin üzerine yazılacaktı (overwrite)
                                                                          // dolayısıyla mevcut veri kaybedilecekti
        }



        /// <summary>
        /// DosyaYolu özelliği üzerinden dosya adını dönen method.
        /// </summary>
        /// <returns>string</returns>
        public string DosyaAdiGetir() // interface'i implemente ettiğimizden method tanımı üzerinden implemente etmemiz için method oluşturuldu
        {
            string dosya = Path.GetFileName(DosyaYolu); // Path sınıfının GetFileName methodu dosya adı ile birlikte uzantısını döner, örneğin Öğrenciler.txt

            return dosya.Split('.')[0]; // sadece dosya adını dönebilmek için . karakterine göre dosya'yı parçalayıp elde ettiğimiz dizideki ilk elemanı dönüyoruz, örneğin Öğrenciler
        }



        /// <summary>
        /// DosyaYolu özelliği üzerinden dosya uzantısını dönen method.
        /// </summary>
        /// <returns>string</returns>
        public string DosyaUzantisiGetir() // interface'i implemente ettiğimizden method tanımı üzerinden implemente etmemiz için method oluşturuldu
        {
            string dosya = Path.GetExtension(DosyaYolu); // Path sınıfının GetExtension methodu dosya uzantısını döner, örneğin .txt

            return dosya.Substring(1).ToLower(); // sadece dosya uzantısını dönebilmek için dosya üzerinden 1. index'ten başlayıp sona kadar sub string alıyoruz
                                                 // ve tüm karakterleri küçük harfe dönüştürüyoruz, örneğin txt
        }
        #endregion
    }
}
