﻿using _14_ArrayOfObjects_TimeSpan_Casting.Models;
using _14_ArrayOfObjects_TimeSpan_Casting.Models.Bases;
using System.Globalization;

namespace _14_ArrayOfObjects_TimeSpan_Casting
{
    internal class Program
    {
        static void Main(string[] args)
        {
            #region Array of Objects (Obje Dizisi) ve TimeSpan Veri Tipi
            Sarki[] sarkilar = new Sarki[2] // array'i new'lerken içerisindeki elemanları da new'leyip her elemanın özelliklerini set ediyoruz
            {
                new Sarki()
                {
                    Adi = "Kış Güneşi", // Medya base sınıfı özelliği
                    Suresi = new TimeSpan(0, 3, 56), // Medya base sınıfı özelliği.
                                                     // TimeSpan için 1. yöntem: bu overload'da ilk parametre saat, ikinci parametre dakika, üçüncü parametre saniye.
                    CikisTarihi = new DateTime(1994, 04, 17), // Medya base sınıfı özelliği.
                                                              // DateTime için 1. yöntem.
                    TLfiyati = 9.99m, // Medya base sınıfı özelliği.

                    Sanatci = "Tarkan", // Sarki sub sınıfı özelliği
                    Album = "Aacayipsin" // Sarki sub sınıfı özelliği
                    // mp3 formatında olduğu için Sarki sub sınıfı Mp3mu özelliğini atamadığımızda Sarki sınıfında
                    // default (varsayılan) true atadığımızdan Mp3mu özelliğinin değeri true olacak
                },
                new Sarki()
                {
                    Adi = "Dönence", // Medya base sınıfı özelliği
                    Suresi = TimeSpan.Parse("00:06:45"), // Medya base sınıfı özelliği.
                                                         // TimeSpan için 2. yöntem: saat (0), dakika (6) ve saniye (45) için CultureInfo kullanmamıza gerek yok
                                                         // çünkü formatı bölgelere göre değişmiyor.
                    CikisTarihi = DateTime.Parse("23.05.1981", new CultureInfo("tr-TR")), // Medya base sınıfı özelliği.
                                                                                          // DateTime için 2. yöntem: Türkiye bölgesine göre gün.ay.yıl formatı
                    TLfiyati = 4.99M, // Medya base sınıfı özelliği

                    Sanatci = "Barış Manço", // Sarki sub sınıfı özelliği
                    Album = "Sözüm Meclisten Dışarı", // Sarki sub sınıfı özelliği
                    Mp3mu = false  // Sarki sub sınıfı özelliği.
                                   // Bu şarkının formatı mp3 değil, bu yüzden default true değerini kullanmasın diye false atadık.
                }
            };

            Console.WriteLine("*** Şarkılar ***");

            foreach (Sarki sarki in sarkilar)
            {
                Console.WriteLine($"Adı: {sarki.Adi}\n" +
                    $"Süresi: {sarki.Suresi.Minutes} dakika {sarki.Suresi.Seconds} saniye\n" + // MilliSeconds, Seconds, Minutes, Hours ve Days özellikleri
                                                                                               // milisaniye, saniye, dakika, saat ve gün parçasını döner,
                                                                                               // örneğin burada Minutes özelliği atanan dakikayı,
                                                                                               // Seconds özelliği ise atanan saniyeyi dönecek
                    $"Toplam Süresi: {sarki.Suresi.TotalMilliseconds} saniye\n" + // TotalMilliseconds, TotalSeconds, TotalMinutes, TotalHours ve TotalDays gibi
                                                                                  // Total ile başlayan özellikler
                                                                                  // milisaniye, saniye, dakika, saat veya gün cinsinden toplamı döner,
                                                                                  // örneğin burada şarkının toplam saniyesini dönecek
                    $"Çıkış Tarihi: {sarki.CikisTarihi.ToString("dd.MM.yyyy")}\n" + // ToString methodu üzerinden gün(dd).ay(MM).yıl(yyyy) formatında tarihi dönecek
                    $"Sanatçı: {sarki.Sanatci}\n" +
                    $"Albüm: {sarki.Album}\n" +
                    $"Fiyatı: {sarki.TLfiyati} TL\n" +
                    $"Formatı: {(sarki.Mp3mu ? "Mp3" : "Diğer")}\n");
            }



            Film[] filmler = new Film[3]; // önce array'i oluşturuyoruz

            filmler[0] = new Film(); // sonra her bir array index'indeki elemanı new'liyoruz ve her elemanın özelliklerini set ediyoruz
            filmler[0].Adi = "Baby Driver"; // Medya base sınıfı özelliği
            filmler[0].Suresi = TimeSpan.Parse("01:53:00"); // Medya base sınıfı özelliği
            filmler[0].CikisTarihi = DateTime.Parse("28.06.2017", new CultureInfo("tr-TR")); // Medya base sınıfı özelliği
            filmler[0].TLfiyati = 18.99m; // Medya base sınıfı özelliği
            filmler[0].GoruntuFormati = Enums.GoruntuFormati.UltraHD; // Video base sınıfı özelliği
            filmler[0].Yonetmen = "Edgar Wright"; // Film sub sınıfı özelliği
            filmler[0].Oyuncular = new string[] { "Ansel Elgort", "Lily James", "Kevin Spacey", "Jon Hamm", "Jamie Foxx" }; // Film sub sınıfı özelliği
            filmler[0].ImdbPuani = 7.6F;

            filmler[1] = new Film();
            filmler[1].Adi = "The Matrix"; // Medya base sınıfı özelliği
            filmler[1].Suresi = TimeSpan.Parse("02:16"); // Medya base sınıfı özelliği, saniye 0 ise yazmak zorunlu değil
            filmler[1].CikisTarihi = DateTime.Parse("03.09.1999", new CultureInfo("tr-TR")); // Medya base sınıfı özelliği
            filmler[1].TLfiyati = 9.99M; // Medya base sınıfı özelliği
            filmler[1].GoruntuFormati = Enums.GoruntuFormati.HD; // Video base sınıfı özelliği
            filmler[1].Yonetmen = "Wachowski Kardeşler"; // Film sub sınıfı özelliği
            filmler[1].Oyuncular = new string[4] { "Keanu Reeves", "Carrie-Anne Moss", "Laurence Fishburne", "Hugo Weaving" }; // Film sub sınıfı özelliği
            filmler[1].ImdbPuani = 8.7f;

            filmler[2] = new Film();
            filmler[2].Adi = "Eşkiya"; // Medya base sınıfı özelliği
            filmler[2].Suresi = TimeSpan.Parse("02:03"); // Medya base sınıfı özelliği, saniye 0 ise yazmak zorunlu değil
            filmler[2].CikisTarihi = DateTime.Parse("29.11.1996", new CultureInfo("tr-TR")); // Medya base sınıfı özelliği
            filmler[2].TLfiyati = 4.99m; // Medya base sınıfı özelliği
            filmler[2].GoruntuFormati = Enums.GoruntuFormati.SD; // Video base sınıfı özelliği
            filmler[2].Yonetmen = "Yavuz Turgul"; // Film sub sınıfı özelliği
            filmler[2].Oyuncular = new string[] { "Şener Şen", "Uğur Yücel" }; // Film sub sınıfı özelliği
            filmler[2].ImdbPuani = 8.1F;

            Console.WriteLine("*** Filmler ***");

            string oyuncular ; // filmin oyuncularını konsola yazdırmak için tanımladık 
            string oyuncu; // filmin oyuncular dizisindeki her bir oyuncu
            Film film; // filmler dizisindeki her bir film

            for (int i = 0; i < filmler.Length; i++) // filmleri dönüyoruz
            {
                film = filmler[i]; // i. index'teki Film tipindeki objeyi film değişkenine atıyoruz
                oyuncular = ""; // her bir film için oyuncuları temizliyoruz, dolayısıyla ilk değer olarak "" atadık
                if (film.Oyuncular != null && film.Oyuncular.Length > 0) // eğer filmin oyuncuları varsa
                {
                    for (int j = 0; j < film.Oyuncular.Length; j++) // her bir film için oyuncuları dönüyoruz
                    {
                        oyuncu = film.Oyuncular[j]; // j. index'teki string tipindeki değeri oyuncu değişkenine atıyoruz
                        oyuncular += oyuncu + ", "; // sonuna , ekleyerek oyuncu'yu oyuncular'a concatenate ediyoruz
                    }
                    oyuncular = oyuncular.Substring(0, oyuncular.Length - 2); // en baştan başla, sondan iki karakter hariç sub string alarak oyuncular'a ata,
                                                                              // sondaki ',' ile ' ' karakterlerini temizledik
                }
                Console.WriteLine($"Adı: {film.Adi}\n" +
                    $"Süresi: {film.Suresi.Hours}:{film.Suresi.Minutes}:{film.Suresi.Seconds}\n" + 
                    $"Toplam Süresi: {film.Suresi.TotalMinutes} dakika\n" + 
                    $"Çıkış Tarihi: {film.CikisTarihi.ToShortDateString()}\n" + // ToShortDateString methodu bilgisayarın bölgesel ayarı Türkçe ise
                                                                                // Türkçe formatında (gün.ay.yıl),
                                                                                // değilse o bölgesel ayar formatında tarih döner,
                                                                                // örneğin İngilizce formatı ay/gün/yıl
                    $"Formatı: {film.GoruntuFormati}\n" +
                    $"Yönetmen: {film.Yonetmen}\n" +
                    $"Oyuncular: {oyuncular}\n" +
                    $"Fiyatı: {film.TLfiyati} TL\n" +
                    $"IMDB Puanı: {film.ImdbPuani}\n");
            }
            #endregion



            #region Array of Objects Using Polymorphism (Polymorphism Kullanılan Obje Dizisi) ve is ile as Kullanımı 
            Medya[] medyaDizisi = new Medya[] // base Medya tipinde bir referans değişkeni üzerinden base Medya tipinde bir dizi oluşturuyoruz
            {
                new Video() // dizinin ilk elemanına sub Video tipinde bir obje atıyoruz
                {
                    Adi = "Morcheeba - Enjoy The Ride", // Medya base class'ı özelliği
                    CikisTarihi = DateTime.Parse("18.04.2008", new CultureInfo("tr-TR")), // Medya base class'ı özelliği
                    Suresi = TimeSpan.Parse("00:04:02"), // Medya base class'ı özelliği
                    GoruntuFormati = Enums.GoruntuFormati.HD // Video sub class'ı özelliği
                    // Medya base class'ı TLfiyati özelliğini atamadığımız için otomatik 0 değeri atanacak
                },
                new Sarki() // dizinin ikinci elemanına sub Sarki tipinde bir obje atıyoruz
                {
                    Adi = "I Want It All", // Medya base class'ı özelliği
                    CikisTarihi = DateTime.Parse("01.02.1989", new CultureInfo("tr-TR")), // Medya base class'ı özelliği
                    Suresi = TimeSpan.FromSeconds(297), // 4 dakika 57 saniye
                    TLfiyati = 3.99m,  // Medya base class'ı özelliği
                    Sanatci = "Queen", // Sarki sub class'ı özelliği
                    Album = "The Miracle" // Sarki sub class'ı özelliği
                },
                new Film() // dizinin üçüncü elemanına sub Film tipinde bir obje atıyoruz
                {
                    Adi = "Avatar", // Medya base class'ı özelliği
                    CikisTarihi = DateTime.Parse("18.12.2009", new CultureInfo("tr-TR")), // Medya base class'ı özelliği
                    Suresi = TimeSpan.Parse("02:42"), // Medya base class'ı özelliği
                    TLfiyati = 9.99m, // Medya base class'ı özelliği
                    GoruntuFormati = Enums.GoruntuFormati.UltraHD, // Video base class'ı özelliği
                    Yonetmen = "James Cameron", // Film sub class'ı özelliği
                    Oyuncular = new string[] { "Zoe Saldana", "Sam Worthington", "Sigourney Weaver" }, // Film sub class'ı özelliği
                    ImdbPuani = 7.9f // Film sub class'ı özelliği
                }
            };

            Console.WriteLine("*** Medya ***");

            // bu örnekte medyaDizisi değişkeninin tipi Medya[] olduğundan ve her bir elemanının tipi de Medya olduğundan sadece Medya sınıfı özelliklerini kullanabiliriz
            foreach (Medya medya in medyaDizisi)
            {
                Console.WriteLine($"Medya Adı: {medya.Adi}\n" +
                    $"Medya Süresi: {medya.Suresi.Hours.ToString().PadLeft(2, '0')}:{medya.Suresi.Minutes.ToString().PadLeft(2, '0')}:{medya.Suresi.Seconds.ToString().PadLeft(2, '0')}\n" +
                    $"Medya Çıkış Tarihi: {medya.CikisTarihi.ToShortDateString()}\n" +
                    $"Medya Fiyatı: {medya.TLfiyati} TL\n");
            }

            Console.WriteLine("*** Video, Şarkı, Film ***");

            // ancak medyaDizisi değişkeni sırasıyla Video, Sarki ve Film tipinde objelere refere ettiğinden
            // bu örnekte ihtiyaç halinde ilgili tiplere casting işlemi uygulayarak tip özelliklerini kullanabiliriz
            Video videoElemani; // aşağıdaki döngüde Medya tipindeki referans değişkeninin refere ettiği Medya tipindeki objenin Video tipine cast edilip atanacağı değişken
            Sarki sarkiElemani; // aşağıdaki döngüde Medya tipindeki referans değişkeninin refere ettiği Medya tipindeki objenin Sarki tipine cast edilip atanacağı değişken
            Film filmElemani; // aşağıdaki döngüde Medya tipindeki referans değişkeninin refere ettiği Medya tipindeki objenin Film tipine cast edilip atanacağı değişken
            foreach (Medya medya in medyaDizisi)
            {
                // önce Medya tip özellikleri değerlerini yazdırıyoruz
                Console.WriteLine($"Medya Adı: {medya.Adi}\n" +
                   $"Medya Süresi: {medya.Suresi.ToString(@"hh\:mm\:ss")}\n" +
                   $"Medya Çıkış Tarihi: {medya.CikisTarihi.ToShortDateString()}\n" +
                   $"Medya Fiyatı: {medya.TLfiyati.ToString("N2")} TL");

                // daha sonra Medya tipindeki medya değişkeninin refere ettiği Video, Sarki ve Film tipindeki objelerin tiplerini
                // kontrol edip casting işlemi uyguluyoruz
                if (medya is Film) // eğer medya referans değişkeni Film tipinde bir objeye refere ediyorsa
                {
                    //filmElemani = (Film)medya; // casting işlemi 1. yöntem
                    filmElemani = medya as Film; // casting işlemi 2. yöntem

                    // casting işleminden sonra Film sınıfı ve miras aldığı Video sınıfı özelliklerini kullanabiliriz
                    Console.WriteLine($"Film Yönetmeni: {filmElemani.Yonetmen}\n" +
                       $"Film IMDB Puanı: {filmElemani.ImdbPuani}\n" +
                       $"Film Formatı: {filmElemani.GoruntuFormati}");

                    // filmin her bir oyuncusunu turlayıp konsola yazdırıyoruz
                    if (filmElemani.Oyuncular is not null && filmElemani.Oyuncular.Length > 0) // eğer filmin oyuncuları varsa
                    {
                        Console.WriteLine("Film Oyuncuları:");
                        foreach (string oyuncuElemani in filmElemani.Oyuncular)
                        {
                            Console.Write($"Oyuncu: {oyuncuElemani}\n");
                        }
                    }
                }
                else if (medya is Sarki) // eğer medya referans değişkeni Sarki tipinde bir objeye refere ediyorsa
                {
                    sarkiElemani = medya as Sarki; // casting işlemi

                    // casting işleminden sonra Sarki sınıfı özelliklerini kullanabiliriz
                    Console.WriteLine($"Şarkı Sanatçısı: {sarkiElemani.Sanatci}\n" +
                        $"Şarkı Albümü: {sarkiElemani.Album}\n" +
                        $"Şarkı Formatı: {(sarkiElemani.Mp3mu ? "Mp3" : "Diğer")}\n");
                }
                else //if (medya is Video) // sadece Video tipi kontrolü kaldığından if koşulunu yazmaya gerek yok, eğer medya referans değişkeni Video tipinde bir objeye refere ediyorsa
                {
                    videoElemani = medya as Video; // casting işlemi

                    // casting işleminden sonra Video sınıfı özelliklerini kullanabiliriz
                    Console.WriteLine($"Video Formatı: {videoElemani.GoruntuFormati}\n");
                }
            }
            #endregion
        }
    }
}