﻿namespace _16_AccessibilityModifiers
{
    // Accessibility Modifiers (Visibility Modifiers) erişim belirleyicileridir.

    // Class'lardaki field (alan), property (özellik) ve behavior'ların (davranış, method) ilk olarak class içerisinde,
    // daha sonra inheritance (kalıtım) üzerinden class'tan miras alan sub class'lar içerisinde ve
    // son olarak da class'lardan oluşturulan obje referans değişkenleri üzerinden erişimlerinin yönetilmesini sağlar.

    // Dar erişimden geniş erişime doğru private, protected, internal ve public başlıca erişim belirleyicileridir.

    // 1) private, protected, internal veya public erişim belirleyicilerine sahip alan, özellik veya methodlara
    // kullanıldıkları sınıf içerisindeki method veya constructor'lar içerisinde erişilebilir.

    // 2) protected, internal ve public erişim belirleyicilerine sahip alan, özellik veya methodlara
    // miras aldıkları sınıf (sub class) içerisindeki method veya constructor'lar içerisinde erişilebilir.

    // 3) internal ve public erişim belirleyicilerine sahip alan, özellik veya methodlara
    // oluşturuldukları obje referans değişkeni üzerinden erişilebilir.

    // 4) internal sınıf içerisinde, kalıtımda ve obje referans değişkeni üzerinden public ile aynı erişim kullanımına sahiptir.
    // genelde alan, özellik veya methodlarda internal kullanılmaz.
    // Tek farkı internal tanımlanan sınıflara sadece aynı proje (assembly: proje kodlarının makine diline derlenmiş hali)
    // içerisinde erişilebilirken, public tanımlanan sınıflara başka projeler (farklı assembly'ler) üzerinden de .dll veya .exe
    // referansları projeye eklendikten sonra erişilebilir.



    public class Base // sınıflar genelde public veya internal tanımlanır,
                      // sınıflarda eğer erişim belirleyici yazılmazsa varsayılan (default) internal'dır,
                      // genelde tüm sınıflar için aynı erişim belirleyicisi kullanılır,
                      // bu sınıfın method ve constructor'larında sınıfın altında tanımlanan
                      // tüm alan, özellik ve methodlara erişilebilir
    {
        #region Private Class İçi Kullanımı
        private bool _private1; // private erişim belirleyicisine sahip alanların genelde başında _ kullanılır,
                                // değer ataması yapılmadığı için varsayılan değeri false'dur

        byte _private2 = 2; // private byte _private2 = 2; ile aynı,
                            // alanlarda eğer erişim belirleyici yazılmazsa varsayılan private'dır,
                            // eğer istenirse alanlara ilk değer ataması yapılabilir

        private short Private3 { get; set; } = 3; // özellikler genelde private tanımlanmaz,
                                                  // eğer istenirse özelliklere ilk değer ataması yapılabilir

        private void SetBasePrivate()
        {
            bool local1 = true; // içerisinde kullanıldığı methodun local değişkeni,
                                // bu değişkene bu sınıfın başka methodları üzerinden erişilemez

            _private1 = local1;
            _private2 = 22;
            Private3 = 33;
        }

        void DisplayBasePrivate1() // private void DisplayBasePrivate1() ile aynı,
                                   // methodlarda eğer erişim belirleyici yazılmazsa varsayılan private'dır
        {
            // local1 değişkeni SetBasePrivate methodu sınırı (scope) içerisinde tanımlandığından bu method içerisinden erişilemez
            /*
            Console.WriteLine("local1:" + local1); 
            */

            Console.WriteLine("_private1: " + _private1);
            Console.WriteLine("_private2: " + _private2);
            Console.WriteLine("Private3: " + Private3);
        }

        private void DisplayBasePrivate2() 
        {
            DisplayBasePrivate1();
        }
        #endregion



        #region Protected Class İçi Kullanımı
        protected int protected1; // değer ataması yapılmadığı için varsayılan değeri 0'dır

        protected long Protected2 { get; set; } // değer ataması yapılmadığı için varsayılan değeri 0'dır

        protected void SetBaseProtected()
        {
            _private1 = false;
            _private2 = 222;
            Private3 = 333;

            protected1 = 1;
            Protected2 = 2;
        }

        protected void DisplayBaseProtected1()
        {
            DisplayBasePrivate2();

            Console.WriteLine("protected1: " + protected1);
            Console.WriteLine("Protected2: " + Protected2);
        }

        protected void DisplayBaseProtected2()
        {
            DisplayBaseProtected1();
        }
        #endregion



        #region Public Class İçi Kullanımı
        public double public1; // alanlar genelde public tanımlanmaz,
                               // değer ataması yapılmadığı için varsayılan değeri 0'dır

        public string Public2 { get; set; } // değer ataması yapılmadığı için varsayılan değeri null'dır

        public void SetBasePublic()
        {
            _private1 = true;
            _private2 = 22;
            Private3 = 33;

            protected1 = 11;
            Protected2 = 22;

            public1 = 1;
            Public2 = "2";
        }

        public void DisplayBasePublic()
        {
            DisplayBaseProtected2();

            Console.WriteLine("public1: " + public1);
            Console.WriteLine("Public2: " + Public2);
        }
        #endregion
    }



    class Sub : Base // internal class Sub : Base ile aynı 
    {
        #region Private Kalıtım Üzerinden Kullanımı (Kullanılamaz)
        private void DisplaySubPrivate()
        {
            // private tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilemez
            /*
            local1 = false; // local1 değişkeni SetBasePrivate methodu sınırı (scope) içerisinde tanımlandığından
                            // bu method içerisinden erişilemez
            _private1 = true;
            _private2 = 9;
            Private3 = 8;
            DisplayBasePrivate2();
            */
        }
        #endregion



        #region Protected Kalıtım Üzerinden Kullanımı
        protected void DisplaySubProtected()
        {
            // private tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilemez
            /*
            _private1 = false;
            _private2 = 99;
            Private3 = 88;
            DisplayBasePrivate2();
            */

            // protected tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilebilir
            protected1 = 9;
            Protected2 = 8;
            DisplayBaseProtected2();
        }
        #endregion



        #region Public Kalıtım Üzerinden Kullanımı
        public void DisplaySubPublic()
        {
            // private tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilemez
            /*
            _private1 = true;
            _private2 = 9;
            Private3 = 8;
            DisplayBasePrivate2();  
            */

            // protected tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilebilir
            protected1 = 99;
            Protected2 = 88;
            DisplayBaseProtected2();

            // public tanımlanan alan, özellik veya methodlara miras alan sınıfın method ve constructor'ları içerisinde erişilebilir
            public1 = 9;
            Public2 = "8";
            DisplayBasePublic();
        }
        #endregion
    }



    internal class Program
    {
        static void Main(string[] args)
        {
            Base parent = new Base(); // Base tip objesi initialization
            Sub child = new Sub(); // Sub tip objesi initialization



            #region Private Obje Üzerinden Kullanımı (Kullanılamaz)
            // private tanımlanan alan, özellik veya methodlara ne base ne de sub objeler üzerinden erişilemez 
            /*
            parent._private1 = false;
            parent._private2 = 4;
            parent.Private3 = 5;
            parent.DisplayBasePrivate2();
            */
            #endregion



            #region Protected Obje Üzerinden Kullanımı (Kullanılamaz)
            // protected tanımlanan alan, özellik veya methodlara ne base ne de sub objeler üzerinden erişilemez 
            /*
            parent.protected1 = true;
            parent.Protected2 = 44;
            parent.DisplayBaseProtected2();
            */
            #endregion



            #region Public Obje Üzerinden Kullanımı
            // public tanımlanan alan, özellik veya methodlara hem base hem de sub objeler üzerinden erişilebilir
            parent.public1 = 6;
            parent.Public2 = "7";
            parent.DisplayBasePublic();

            child.public1 = 66;
            child.Public2 = "77";
            child.DisplayBasePublic();
            child.DisplaySubPublic();
            #endregion
        }
    }
}