﻿using System.Collections;

namespace _17_ArrayListCollectionType
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Collections (koleksiyonlar) dinamik array (dizi) objeleridir.
            // Dizilerin eleman sayıları sabitken koleksiyonların eleman sayıları eleman ekleme
            // ve çıkarma işlemlerine göre dinamik olarak değişir.
            // ArrayList, List, Dictionary ve Hashtable başlıca bazı koleksiyon tipleridir.
            // Queue (ilk eklenen ilk çıkar) ve Stack (ilk eklenen son çıkar) ise
            // ihtiyaca özel kullanılabilecek koleksiyon tiplerindendir.



            #region Arrays
            string[] isimler = new string[3];
            isimler[0] = "Angel";
            isimler[1] = "Leo";
            isimler[2] = "Luna";

            //isimler[3] = "Çağıl"; // index out of bounds (index dizi sınırının dışındadır)
            // run-time exception (çalışma zamanı beklenmedik hatası) fırlatacaktır
            // çünkü dizi 3 eleman tutabilecek şekilde tanımlanmıştır

            Console.WriteLine("*** Arrays ***");

            Console.WriteLine("İsimler Dizisi:");

            // 3 elemanlı isimler dizisini konsola yazdırma
            foreach (string isim in isimler)
            {
                Console.WriteLine(isim);
            }

            Console.WriteLine();

            // isimler dizisine yeni bir eleman ekleyebilmenin tek yolu yeniden 4 elemanlı şekilde new'lemektir,
            // ancak bu doğru bir yöntem değildir çünkü daha önce isimler referans değişkeni 3 elemanlı bir diziyi
            // refere ederken tekrar new'lediğimizde 4 elemanlı bir diziyi refere edecektir,
            // dolayısıyla hafızada 3 elemanlı ve 4 elemanlı iki tane dizi için yer ayrılacaktır
            isimler = new string[4];

            // yeni bir dizi oluşturduğumuzdan elemanlarını tekrar doldurmalıyız
            isimler[0] = "Angel";
            isimler[1] = "Leo";
            isimler[2] = "Luna";

            isimler[3] = "Çağıl"; // yeni elemanı diziye eklemiş olduk

            // 4 elemanlı isimler dizisini konsola yazdırma
            foreach (string isim in isimler)
            {
                Console.WriteLine(isim);
            }

            Console.WriteLine();

            // elemanları dinamik olarak yönetebilmek için (ekleme ve çıkarma)
            // dizi kullanmak yerine koleksiyon kullanmak doğrudur
            #endregion



            #region ArrayList Collection Type
            // ArrayList bir class'tır ve dinamik olarak bir koleksiyonu yönetebilmemizi sağlar,
            // içerisinde obje elemanları tutar

            // ArrayList objesini initialize ederken (oluştururken) elemanlarını doldurma
            ArrayList isimListesi = new ArrayList() 
            {
                "Angel",
                "Leo",
                "Luna"
            };

            Console.WriteLine("*** ArrayList ***");

            Console.WriteLine("İsimler Koleksiyonu:");

            // 3 elemanlı ArrayList objesini konsola yazdırma
            foreach (string isimElemani in isimListesi) // foreach (var isimElemani in isimListesi) şeklinde var da kullanılabilir
            {
                Console.WriteLine(isimElemani);
            }

            // isimListesi referans değişkeni üzerinden objeyi oluşturduktan sonra yeniden new'leme yapmadan
            // ve daha önce eklediklerimizi kaybetmeden istediğimiz kadar yeni eleman ekleyebiliriz
            isimListesi.Add("Çağıl");

            Console.WriteLine();

            // 4 elemanlı ArrayList objesini konsola yazdırma,
            // tıpkı array'lerde olduğu gibi collection'larda index üzerinden istenilen elemana ulaşılabilir

            for (int i = 0; i < isimListesi.Count; i++) // array'lerde eleman sayısı için Length özelliği kullanılırken
                                                        // collection'larda Count özelliği kullanılır
            {
                Console.WriteLine(isimListesi[i]);
            }

            Console.WriteLine();
            
            Console.WriteLine($"3. index'teki eleman: {isimListesi[3]}"); // konsola "3. index'teki eleman: Çağıl" yazdıracaktır

            Console.WriteLine();

            // eğer çalıştığımız koleksiyon elemanları type safe değilse (yani elemanların tiplerini bilmiyorsak)
            // ArrayList kullanırız, dolayısıyla istediğimiz tipte eleman ekleyebiliriz
            isimListesi.Add(43);
            isimListesi.Add('E');
            isimListesi.Add(true);
            isimListesi.Add(1.75);

            // 8 elemanlı ArrayList objesini konsola yazdırma
            foreach (var isimElemani in isimListesi)
            {
                Console.WriteLine(isimElemani);
            }
            #endregion
        }
    }
}