﻿namespace _18_CollectionMethods.Demos._2_IsimBulma
{
    public class IsimBulmaDemo
    {
        #region İsim Bulma Demo'yu Çalıştıran Method
        public void Calistir()
        {
            Console.WriteLine("\n*** İsim Bulma Demo ***");

            // local değişkenler
            List<string> isimler = new List<string>(); // isimler referans değişkeni üzerinden string tipindeki List objesi initialization
            string giris;
            string bulunanIsim;

            Console.Write("İsim listesine eklenecek isim giriniz: (ç: çıkış) ");
            giris = Console.ReadLine();



            #region İsim Listesini Doldurma
            while (giris != "ç") // kullanıcı ç girmediği sürece döngü devam edecek
            {
                isimler.Add(giris); // kullanıcının girdiği ismi listeye ekliyoruz

                Console.Write("İsim listesine eklenecek isim giriniz: (ç: çıkış) ");
                giris = Console.ReadLine();
            }
            #endregion



            if (isimler.Count > 0) // eğer kullanıcı isimler koleksiyonuna en az bir isim girdiyse
            {
                #region İsim Arama
                // döngü koşulu için ilk giris değerini alma
                Console.Write("İsim arama işlemi seçiniz: (t: tam isim, p: ismin parçası, ç: çıkış) ");
                giris = Console.ReadLine();

                while (giris != "ç") // döngü koşulu olarak kullanıcı ç girmediği sürece döngü devam edecek
                {
                    bulunanIsim = null; // ilk başta ismi bulamadığımızı varsayıyoruz

                    if (giris == "t" || giris == "p") // kullanıcı tam isim veya parçalı isim seçtiyse
                    {
                        if (giris == "t") // kullanıcı tam isim seçtiyse
                        {
                            Console.Write("Aranacak tam ismi giriniz: ");
                            giris = Console.ReadLine();

                            // 1. yöntem:
                            //foreach (string isim in isimler) // isimler koleksiyonundaki her bir isim için
                            //{
                            //    if (isim == giris) // eğer döngü turundaki isim giris'e eşitse
                            //    {
                            //        bulunanIsim = isim; // döngü turundaki ismi bulunanIsim'e atıyoruz
                            //        break; // ismi bulduğumuz için döngüye devam etmeye gerek olmadığından döngüyü kırıyoruz
                            //    }
                            //}

                            // 2. yöntem:
                            int bulunanIsimIndex = isimler.IndexOf(giris); // giris'in isimler koleksiyonundaki index'ini alıyoruz
                            if (bulunanIsimIndex != -1) // eğer bulunanIsimIndex -1 değilse, giris isimler koleksiyonunda bulunmuş demektir
                            {
                                bulunanIsim = isimler[bulunanIsimIndex]; // ismi koleksiyondaki bulunanIsimIndex'i üzerinden bulunanIsim'e atıyoruz
                            }
                        }
                        else // if (giris == "p") // son koşul olduğu için if kısmını yazmaya gerek yok, kullanıcı ismin parçası seçtiyse
                        {
                            Console.Write("Aranacak ismin parçasını giriniz: ");
                            giris = Console.ReadLine();

                            foreach (string isim in isimler) // isimler koleksiyonundaki her bir isim için
                            {
                                if (isim.Contains(giris)) // eğer döngü turundaki isim giris'i içeriyorsa
                                {
                                    bulunanIsim = isim; // döngü turundaki ismi bulunanIsim'e atıyoruz
                                    break; // ismi bulduğumuz için döngüye devam etmeye gerek olmadığından döngüyü kırıyoruz
                                }
                            }
                        }

                        // arama sonucunu yazdırma
                        // 1. yöntem:
                        //if (bulunanIsim is null) // if (bulunanIsim == null) da yazılabilir
                        //    Console.WriteLine("Aradığınız isim bulunamadı!");
                        //else
                        //    Console.WriteLine($"Aradığınız isim bulundu: \"{bulunanIsim}\".");

                        // 2. yöntem:
                        Console.WriteLine(bulunanIsim is null ? "Aradığınız isim bulunamadı!" : $"Aradığınız isim bulundu: \"{bulunanIsim}\".");
                    }

                    // döngü koşulu için alınan giris değerini güncelleme
                    Console.Write("İsim arama işlemi seçiniz: (t: tam isim, p: ismin parçası, ç: çıkış) ");
                    giris = Console.ReadLine();
                }
                #endregion
            }
        }
        #endregion
    }
}
