﻿namespace _18_CollectionMethods.Demos._3_Organizasyonlar.Models
{
    /// <summary>
    /// Doğum günü, düğün vb. organizasyon bilgilerini yönetmek için model sınıfı.
    /// </summary>
    public class Organizasyon
    {
        #region Properties
        public int Id { get; set; }
        public string Adi { get; set; }
        public string Duzenleyeni { get; set; }
        public DateTime BaslangicTarihiVeSaati { get; set; }
        public TimeSpan Suresi { get; set; }



        // BaslangicTarihiVeSaati ile Sure özellikleri üzerinden atanan readonly (sadece okunur) özellik
        // 1. yöntem:
        //public DateTime BitisTarihiVeSaati
        //{
        //    get
        //    {
        //        return BaslangicTarihiVeSaati.Add(Suresi);
        //    }
        //}
        // 2. yöntem:
        public DateTime BitisTarihiVeSaati => BaslangicTarihiVeSaati.Add(Suresi);
        #endregion
    }
}
