﻿using _22_DependencyInjection.Demos.Bases;

namespace _22_DependencyInjection.Demos
{
    public class ArabaVeSurucuDemo
    {
        public void Calistir()
        {
            Araba araba;

            SurucuBase surucu1 = new Surucu() // arabaya enjekte edilecek 1. sürücü
            {
                Isim = "Luna Alsaç"
            };
            SurucuBase surucu2 = new Surucu() // arabaya enjekte edilebilecek 2. sürücü
            {
                Isim = "Leo Jr. Alsaç"
            };

            araba = new Araba(surucu1); // 1. sürücünün arabaya enjekte edilmesi,
                                        // araba = new Araba(surucu2);
                                        // üzerinden 1. sürücü yerine 2. sürücü arabaya enjekte edilebilir
            
            araba.Sur(); // konsola 1. sürücü için "Araba Luna Alsaç tarafından sürülüyor.",
                         // 2. sürücü içinse "Araba Leo Jr. Alsaç tarafından sürülüyor." yazdıracaktır,
                         // dolayısıyla tek bir araba objesinin sürücü objesini değiştirerek arabanın
                         // farklı sürücüler tarafından sürülebilmesini sağlamış olduk
        }
    }
}
