﻿using _22_DependencyInjection.Logging.Bases;

namespace _22_DependencyInjection.Logging.Repositories
{
    public class ProductRepo // ürün ekleme ve silme işlemlerini gerçekleştiren somut repository class'ı
    {
        private readonly ILogger _logger; // sadece bu class'a özel readonly (sadece okunur: değeri sadece sınıf
                                          // altında tanımlanan alan üzerinden (_logger) veya
                                          // constructor üzerinden atanabilir, methodlarda atanamaz)
                                          // bir alan tanımlanır

        public ProductRepo(ILogger logger) // constructor'a yukarıdaki alan ile aynı soyut base tipte
                                              // bir parametre üzerinden obje referansı gönderilir
        {
            _logger = logger; // parametre olarak gelen referans değişkeni sınıfın alanına atanır,
                              // böylelikle alan üzerinden sınıfın methodlarında işlemler gerçekleştirilebilir
        }

        public void Add() // ekleme methodu hem ürün ekleme işlemini gerçekleştirir hem de enjekte edilen _logger alanı
                          // üzerinden loglama işlemi gerçekleştirilir
        {
            Console.WriteLine("Ürün eklendi.");
            _logger.Log();
        }

        public void Delete() // silme methodu hem ürün silme işlemini gerçekleştirir hem de enjekte edilen _logger alanı
                             // üzerinden loglama işlemi gerçekleştirilir
        {
            Console.WriteLine("Ürün silindi.");
            _logger.Log();
        }
    }
}
