﻿namespace _23_ValueAndReferenceTypes.ReferenceTypes
{
    public class ReferenceTypesDemo2
    {
        public void Calistir()
        {
            Sehir sehir1 = new Sehir() { Adi = "Zonguldak" }; // atama referans üzerinden gerçekleşir,
                                                              // sehir1 Adi özelliği olarak Zonguldak atanmış objeyi refere eder,
                                                              // örneğin sehir1'in obje için tuttuğu adres E3F3 olsun

            Sehir sehir2 = new Sehir() { Adi = "Yalova" }; // örneğin sehir2'nin obje için tuttuğu adre G4H4 olsun

            Console.WriteLine($"1) Şehir 1: {sehir1.Adi}, Şehir 2: {sehir2.Adi}");
            // konsola "1) Şehir 1: Zonguldak, Şehir 2: Yalova" yazdırır

            sehir1 = sehir2; // atama referans üzerinden gerçekleşir yani E3F3 olan sehir1'in adresi G4H4 olur 

            Console.WriteLine($"2) Şehir 1: {sehir1.Adi}, Şehir 2: {sehir2.Adi}");
            // konsola "2) Şehir 1: Yalova, Şehir 2: Yalova" yazdırır

            sehir2.Adi = "İzmir"; // hem sehir1 hem de sehir2 referans değişkenleri G4H4 adresi üzerinden Adi özelliği Yalova olarak atanmış
                                  // objeyi refere ettiğinden, sehir2'nin Adi özelliğinin İzmir atanması sonucu objenin Adi özelliği
                                  // İzmir olarak güncellenir ve hem sehir1.Adi hem de sehir2.Adi, Adi özelliği İzmir olan aynı objeye ulaşır

            Console.WriteLine($"3) Şehir 1: {sehir1.Adi}, Şehir 2: {sehir2.Adi}");
            // konsola "2) Şehir 1: İzmir, Şehir 2: İzmir" yazdırır
        }
    }



    class Sehir
    {
        public string Adi { get; set; }
    }
}
