﻿using _25_HasArelationship._1_GokCisimleri.Entities;
using _25_HasArelationship._1_GokCisimleri.Entities.Bases;
using System.Globalization;

namespace _25_HasArelationship._1_GokCisimleri.Repositories
{
    public class GokCismiRepo
    {
        private CultureInfo cultureInfo = new CultureInfo("tr-TR");

        private List<GokCismiBase> _gokCisimleri;



        /// <summary>
        /// _gokCisimleri koleksiyonunu oluşturur.
        /// </summary>
        public GokCismiRepo()
        {
            _gokCisimleri= new List<GokCismiBase>();

            Yildiz gunes = new Yildiz()
            {
                Adi = "Güneş",
                KendiEtrafindaDonmeHizi = 2000,
                SicaklikC = 5500,
                YariCapi = 696340,
                Gezegenler = new List<Gezegen>() // has-a relationship: bir yıldızın 0 veya daha çok gezegeni olabilir
            };

            Gezegen mars = new Gezegen()
            {
                Adi = "Mars",
                KendiEtrafindaDonmeHizi = 3000,
                YariCapi = 3389.5,
                YasamVarMi = false,
                //Uydular = new List<Uydu>(), // Gezegen class'ının constructor'ında zaten new'ledik,
                                              // has-a relationship: bir gezegenin 0 veya daha çok uydusu olabilir
                Yildiz = gunes // has-a relationship: bir gezegenin bir yıldızı olabilir
            };

            gunes.Gezegenler.Add(mars); // has-a relationship: yıldızın gezegenlerine gezegeni ekliyoruz

            Gezegen dunya = new Gezegen()
            {
                Adi = "Dünya",
                KendiEtrafindaDonmeHizi = 3500,
                YariCapi = 6371,
                YasamVarMi = true,
                Yildiz = gunes // has-a relationship: bir gezegenin bir yıldızı olabilir
            };

            gunes.Gezegenler.Add(dunya); // has-a relationship: yıldızın gezegenlerine gezegeni ekliyoruz

            Uydu ay = new Uydu()
            {
                Adi = "Ay",
                YariCapi = 1737.4,
                KendiEtrafindaDonmeHizi = 4000,
                Gezegen = dunya // has-a relationship: bir uydunun bir gezegeni olabilir
            };

            dunya.Uydular.Add(ay); // has-a relationship: gezegenin uydularına uyduyu ekliyoruz

            // gök cisimlerine yıldızı, gezegenleri ve uyduyu ekliyoruz
            _gokCisimleri.Add(gunes);
            _gokCisimleri.Add(mars);
            _gokCisimleri.Add(dunya);
            _gokCisimleri.Add(ay);
        }



        /// <summary>
        /// _gokCisimleri koleksiyonu üzerinden Yildiz, Gezegen veya Uydu tiplerindeki elemanları içeren koleksiyonu döner.
        /// </summary>
        /// <returns>List<GokCismiBase></returns>
        public List<GokCismiBase> Getir(GokCismiTipi tipi = GokCismiTipi.Tumu)
        {
            List<GokCismiBase> sonucGokCisimleri = new List<GokCismiBase>();

            foreach (GokCismiBase gokCismi in _gokCisimleri)
            {
                if (gokCismi is Yildiz && tipi == GokCismiTipi.Yildiz)
                {
                    //sonucGokCisimleri.Add(gokCismi as Yildiz); // Yildiz tipindeki eleman
                    sonucGokCisimleri.Add(gokCismi); // casting'e gerek yok çünkü gokCismi Yildiz tipindeki elemana refere ediyor
                }
                else if (gokCismi is Gezegen && tipi == GokCismiTipi.Gezegen)
                {
                    //sonucGokCisimleri.Add(gokCismi as Gezegen); // Gezegen tipindeki eleman
                    sonucGokCisimleri.Add(gokCismi); // casting'e gerek yok çünkü gokCismi Gezegen tipindeki elemana refere ediyor
                }
                else if (gokCismi is Uydu && tipi == GokCismiTipi.Uydu)
                {
                    //sonucGokCisimleri.Add(gokCismi as Uydu); // Uydu tipindeki eleman
                    sonucGokCisimleri.Add(gokCismi); // casting'e gerek yok çünkü gokCismi Uydu tipindeki elemana refere ediyor
                }
                else if (tipi == GokCismiTipi.Tumu)
                {
                    sonucGokCisimleri.Add(gokCismi);
                }
            }

            return sonucGokCisimleri;
        }



        /// <summary>
        /// _gokCisimleri koleksiyonu üzerinden adiEsitMi parametresine göre adi parametresi 
        /// gök cismi adına eşit olan veya gök cismi adını içeren elemanları döner.
        /// </summary>
        /// <param name="adi"></param>
        /// <param name="adiEsitMi"></param>
        /// <returns>List<GokCismiBase></returns>
        public List<GokCismiBase> Getir(string adi, bool adiEsitMi)
        {
            List<GokCismiBase> sonucGokCisimleri = new List<GokCismiBase>();
            
            foreach (GokCismiBase gokCismi in _gokCisimleri)
            {
                if (adiEsitMi) // eşit: equals
                {
                    // 1. yöntem:
                    //if (gokCismi.Adi.ToLower() == adi.ToLower().Trim()) // ToLower methodu ile eşitliğin iki tarafı için de
                                                                          // büyük küçük harf duyarlılığını ortadan kaldırıyoruz,                                           
                                                                          // parametre olarak gelen adi içersindeki boşlukları da temizliyoruz

                    // 2. yöntem:
                    if (gokCismi.Adi.Equals(adi.Trim(), StringComparison.OrdinalIgnoreCase)) // Equals ve Contains methodları büyük küçük
                                                                                             // harf duyarlılığını ortadan kaldırmak için
                                                                                             // StringComparison enum'ı tipinde ikinci
                                                                                             // bir parametre de alabilir,
                                                                                             // OrdinalIgnoreCase üzerinden binary
                                                                                             // olarak büyük küçük harf duyarlılığı
                                                                                             // ortadan kaldırılabilir
                    {
                        sonucGokCisimleri.Add(gokCismi);
                    }
                }
                else // içeren: contains
                {
                    // 1. yöntem:
                    //if (gokCismi.Adi.ToLower().Contains(adi.ToLower().Trim()))

                    // 2. yöntem:
                    if (gokCismi.Adi.Contains(adi.Trim(), StringComparison.OrdinalIgnoreCase))
                    {
                        sonucGokCisimleri.Add(gokCismi);
                    }
                }
            }

            return sonucGokCisimleri;
        }



        /// <summary>
        /// Parametre olarak gönderilen gokCisimleri koleksiyonundaki elemanları tiplerine göre konsola yazdırır.
        /// </summary>
        /// <param name="gokCisimleri"></param>
        public void Yazdir(List<GokCismiBase> gokCisimleri)
        {
            Yildiz yildiz;
            Gezegen gezegen;
            Uydu uydu;

            foreach (GokCismiBase gokCismi in gokCisimleri)
            {
                if (gokCismi is Yildiz)
                {
                    yildiz = gokCismi as Yildiz;
                    Console.WriteLine("\nTipi: Yıldız\n" +
                        $"Adı: {yildiz.Adi}\n" +
                        $"Yarı Çapı: {yildiz.YariCapi.ToString(cultureInfo)} km\n" +
                        $"Kendi Etrafında Dönme Hızı: {yildiz.KendiEtrafindaDonmeHizi.ToString(cultureInfo)} km/h\n" +
                        $"Sıcaklık: {yildiz.SicaklikC.ToString(cultureInfo)} C ({yildiz.SicaklikF.ToString(cultureInfo)} F)");
                    if (yildiz.Gezegenler is not null) // if (yildiz.Gezegenler != null) da yazılabilir,
                                                       // yıldızın gezegenlerinin null olma ihtimali var
                    {
                        if (yildiz.Gezegenler.Count > 0)
                        {
                            Console.WriteLine("Gezegenler:");
                            foreach (Gezegen yildizGezegeni in yildiz.Gezegenler)
                            {
                                Console.WriteLine(yildizGezegeni.Adi);
                            }
                        }
                    }
                }
                else if (gokCismi is Gezegen)
                {
                    gezegen = gokCismi as Gezegen;
                    Console.WriteLine("\nTipi: Gezegen\n" +
                        $"Adı: {gezegen.Adi}\n" +
                        $"Yarı Çapı: {gezegen.YariCapi.ToString(cultureInfo)} km\n" +
                        $"Kendi Etrafında Dönme Hızı: {gezegen.KendiEtrafindaDonmeHizi.ToString(cultureInfo)} km/h\n" +
                        $"Yaşam: {(gezegen.YasamVarMi ? "Var" : "Yok")}");
                    if (gezegen.Uydular.Count > 0) // gezegenin uydularının null olma ihtimali yok
                                                   // çünkü Gezegen sınıfının constructor'ında Uydular'ı new'ledik
                    {
                        Console.WriteLine("Uydular:");
                        foreach (Uydu gezegenUydusu in gezegen.Uydular) 
                        {
                            Console.WriteLine(gezegenUydusu.Adi);
                        }
                    }
                    if (gezegen.Yildiz is not null) // if (gezegen.Yildiz != null) da yazılabilir,
                                                    // gezegenin yıldızının null olma ihtimali var
                    {
                        Console.WriteLine("Yıldız:\n" + gezegen.Yildiz.Adi);
                    }
                }
                else
                {
                    uydu = gokCismi as Uydu;
                    Console.WriteLine("\nTipi: Uydu\n" +
                        $"Adı: {uydu.Adi}\n" +
                        $"Yarı Çapı: {uydu.YariCapi.ToString(cultureInfo)} km\n" +
                        $"Kendi Etrafında Dönme Hızı: {uydu.KendiEtrafindaDonmeHizi.ToString(cultureInfo)} km/h");
                    if (uydu.Gezegen is not null) // if (uydu.Gezegen != null) da yazılabilir,
                                                  // uydunun gezegeninin null olma ihtimali var
                    {
                        Console.WriteLine("Gezegen:\n" + uydu.Gezegen.Adi);
                    }
                }
            }
        }
    }
}
