﻿using _25_HasArelationship._2_BankaHesaplari.Bases;
using _25_HasArelationship._2_BankaHesaplari.Config;
using _25_HasArelationship._2_BankaHesaplari.Enums;
using System.Globalization;

namespace _25_HasArelationship._2_BankaHesaplari
{
    public class BankaHesaplariDemo
    {
        #region Alanlar
        private List<HesapBase> _hesaplar = new List<HesapBase>(); // has-a relationship: banka hesapları demo 0 veya daha çok hesaba sahiptir
        #endregion



        #region Davranışlar
        public void Calistir()
        {
            string giris = MenuGetir();

            while (giris != "0")
            {
                if (giris == "1")
                {
                    HesapEkle();
                }
                else if (giris == "2")
                {
                    HesaplariListele();
                }
                else if (giris == "3")
                {
                    IslemGerceklestir();
                }
                else if (giris == "4")
                {
                    HesapSil();
                }
                else
                {
                    Console.WriteLine(HesapConfig.GecersizGiris);
                }
                giris = MenuGetir();
            }
        }



        private string MenuGetir()
        {
            Console.Write("\nBanka işlemi (1: yeni hesap ekle, 2: hesapları listele, 3: hesaba işlem gerçekleştir, 4: mevcut hesabı sil, 0: çıkış): ");
            return Console.ReadLine();
        }



        private void HesapEkle()
        {
            string giris, hesapSahibi, hesapKurumu;
            HesapBase hesap;
            IslemBase islem;
            decimal miktar;
            IslemSonucu islemSonucu;
            Console.WriteLine("Yeni Hesap");
            Console.Write("Hesap Tipi: (1: bireysel, 2: kurumsal): ");
            giris = Console.ReadLine();
            if (giris == "1" || giris == "2")
            {
                Console.Write("Hesap sahibinin adı soyadı: ");
                hesapSahibi = Console.ReadLine();
                if (giris == "2")
                {
                    Console.Write("Hesap sahibi kurumun adı: ");
                    hesapKurumu = Console.ReadLine();
                    hesap = new KurumsalHesap()
                    {
                        Sahibi = hesapSahibi,
                        Kurumu = hesapKurumu
                    };
                }
                else
                {
                    hesap = new BireyselHesap()
                    {
                        Sahibi = hesapSahibi
                    };
                }
                hesap.FaizOraniUygula();
                _hesaplar.Add(hesap);
                Console.WriteLine(HesapConfig.HesapEklendi);
                Console.Write("Eklediğiniz hesaba para yatırmak ister misiniz? (1: evet, 2: hayır): ");
                giris = Console.ReadLine();
                if (giris == "1" || giris == "2")
                {
                    if (giris == "1")
                    {
                        IslemGerceklestir(hesap, true);
                    }
                }
                else
                {
                    Console.WriteLine(HesapConfig.GecersizGiris);
                }
            }
            else
            {
                Console.WriteLine(HesapConfig.GecersizGiris);
            }
        }



        private void HesaplariListele()
        {
            string sonuc = "";
            int sayi = _hesaplar.Count;
            BireyselHesap bireyselHesap;
            KurumsalHesap kurumsalHesap;
            if (sayi == 0)
            {
                sonuc = HesapConfig.HesapBulunamadi;
            }
            else
            {
                sayi = 0;
                foreach (HesapBase hesap in _hesaplar)
                {
                    if (hesap.AktifMi) // sadece aktif olan hesapları yazdırıyoruz
                    {
                        if (hesap is BireyselHesap)
                        {
                            bireyselHesap = hesap as BireyselHesap;
                            sonuc += "\nBireysel Hesap";
                            sonuc += $"\nId: {bireyselHesap.Id}";
                            sonuc += $"\nSahibi: {bireyselHesap.Sahibi}";
                            sonuc += $"\nBakiye: {bireyselHesap.ToplamMiktar} TL";
                            sonuc += $"\nFaizli bakiye: {bireyselHesap.FaizliToplamMiktar} TL";
                        }
                        else //if (hesap is KurumsalHesap) // zaten iki tip hesap olduğundan if kısmını yazmaya gerek yok
                        {
                            kurumsalHesap = hesap as KurumsalHesap;
                            sonuc += "\nKurumsal Hesap";
                            sonuc += $"\nId: {kurumsalHesap.Id}";
                            sonuc += $"\nSahibi: {kurumsalHesap.Sahibi}";
                            sonuc += $"\nKurumu: {kurumsalHesap.Kurumu}";
                            sonuc += $"\nBakiye: {kurumsalHesap.ToplamMiktar} TL";
                            sonuc += $"\nFaizli bakiye: {kurumsalHesap.FaizliToplamMiktar} TL";
                        }
                        sayi++;
                    }
                }
                if (sayi > 0)
                    sonuc += "\n" + sayi + " hesap bulundu.";
                else
                    sonuc += HesapConfig.HesapBulunamadi;
            }
            Console.WriteLine(sonuc);
        }



        private HesapBase HesapGetir(int hesapId)
        {
            HesapBase bulunanHesap = null;
            foreach (HesapBase hesap in _hesaplar)
            {
                if (hesap.Id == hesapId)
                {
                    bulunanHesap = hesap;
                    break;
                }
            }
            return bulunanHesap;
        }



        private void IslemGerceklestir(HesapBase hesap, bool paraYatirmaMi)
        {
            Console.Write("Miktar: ");
            decimal miktar = Convert.ToDecimal(Console.ReadLine(), new CultureInfo("tr-TR"));
            IslemSonucu islemSonucu = paraYatirmaMi ? hesap.ParaYatir(miktar) : hesap.ParaCek(miktar);
            Console.WriteLine(HesapConfig.IslemSonucuGetir(islemSonucu));
        }



        private void IslemGerceklestir()
        {
            string giris;
            int hesapId;
            decimal miktar;
            IslemSonucu islemSonucu;
            HesapBase bulunanHesap;
            Console.Write("Hesap işlemi: (1: para yatırma, 2: para çekme): ");
            giris = Console.ReadLine();
            if (giris == "1" || giris == "2")
            {
                HesaplariListele();
                if (_hesaplar.Count > 0)
                {
                    if (giris == "1")
                    {
                        Console.Write("Para yatırma işlemi için hesap id: ");
                        hesapId = int.Parse(Console.ReadLine());
                        bulunanHesap = HesapGetir(hesapId);
                        if (bulunanHesap is null)
                        {
                            Console.WriteLine(HesapConfig.HesapBulunamadi);
                        }
                        else
                        {
                            IslemGerceklestir(bulunanHesap, true);
                        }
                    }
                    else //if (giris == "2") // yazmaya gerek yok çünkü zaten iki koşul var
                    {
                        Console.Write("Para çekme işlemi için hesap id: ");
                        hesapId = int.Parse(Console.ReadLine());
                        bulunanHesap = HesapGetir(hesapId);
                        if (bulunanHesap is null)
                        {
                            Console.WriteLine(HesapConfig.HesapBulunamadi);
                        }
                        else
                        {
                            IslemGerceklestir(bulunanHesap, false);
                        }
                    }
                }
            }
            else
            {
                Console.WriteLine(HesapConfig.GecersizGiris);
            }
        }



        private void HesapSil()
        {
            HesaplariListele();
            if (_hesaplar.Count > 0)
            {
                Console.Write("Silinmek istenen hesap id: ");
                int hesapId = Convert.ToInt32(Console.ReadLine());
                HesapBase bulunanHesap = HesapGetir(hesapId);
                if (bulunanHesap == null)
                {
                    Console.WriteLine(HesapConfig.HesapBulunamadi);
                }
                else
                {
                    bulunanHesap.AktifMi = false;
                    Console.WriteLine(HesapConfig.HesapSilindi);
                }
            }
        }
        #endregion
    }
}
