﻿using _25_HasArelationship._2_BankaHesaplari.Bases;
using _25_HasArelationship._2_BankaHesaplari.Config;

namespace _25_HasArelationship._2_BankaHesaplari
{
    /// <summary>
    /// Hesap base (parent) soyut sınıfından miras alan somut sınıf.
    /// </summary>
    public class KurumsalHesap : HesapBase // is-a relationship: KurumsalHesap bir HesapBase'dir
    {
        #region Özellikler
        /// <summary>
        /// Hesap sahibinin çalıştığı kurum.
        /// </summary>
        public string Kurumu { get; set; }
        #endregion



        #region Davranışlar
        /// <summary>
        /// Kurumsal hesaplar için %20 faiz oranı atar.
        /// </summary>
        public override void FaizOraniUygula() // base sınıftaki soyut olarak tanımlanmış FaizOraniUygula methodunu eziyoruz 
        {
            _faizOrani = HesapConfig.KurumsalFaizOrani;
        }
        #endregion
    }
}
