﻿using _28_1_DemoFilmlerClassLibrary.Entities;
using System.Globalization;

namespace _28_1_DemoFilmlerClassLibrary.Data
{
    public static class Veriler
    {
        public static string KayitBulunamadiMesaji => "Kayıt bulunamadı.";

        public static string HataMesaji => "İşlem sırasında hata meydana geldi!";

        public static int EnSonId { get; set; } = 1;

        public static List<Film> Filmler { get; set; }
        
        public static List<Yonetmen> Yonetmenler { get; set; }

        public static List<Tur> Turler { get; set; }

        static Veriler()
        {
            #region Tür
            Turler = new List<Tur>();
            Turler.Add(new Tur("Aksiyon", EnSonId++));
            Turler.Add(new Tur("Bilim Kurgu", EnSonId++));
            Turler.Add(new Tur("Suç", EnSonId++));
            #endregion

            #region Yönetmen
            Yonetmenler = new List<Yonetmen>()
            {
                new Yonetmen("James", "Cameron", DateTime.Parse("16.08.1954", new CultureInfo("tr-TR")), true, EnSonId++),
                new Yonetmen("Guy", "Ritchie", new DateTime(1968, 9, 10), false, EnSonId++)
            };
            #endregion

            #region Film
            Filmler = new List<Film>();
            Film film = new Film()
            {
                Id = EnSonId++,
                Adi = "Avatar",
                YapimYili = 2009,
                Gisesi = 1000000,
                GosterimTarihi = DateTime.Parse("18.12.2009", new CultureInfo("tr-TR")),
                Platform = Platformlar.Sinema
            };
            film.Yonetmeni = Yonetmenler.First(); // FirstOrDefault da kullanılabilir
            film.Turleri.Add(Turler[0]);
            film.Turleri.Add(Turler[1]);
            Filmler.Add(film);

            film = new Film()
            {
                Id = EnSonId++,
                Adi = "Sherlock Holmes",
                YapimYili = 2009,
                Gisesi = 200000,
                Yonetmeni = Yonetmenler.Last(), // LastOrDefault da kullanılabilir
                GosterimTarihi = new DateTime(2010, 1, 15),
                Platform = Platformlar.Sinema
            };
            film.Turleri.Add(Turler[0]);
            film.Turleri.Add(Turler[2]);
            Filmler.Add(film);
            #endregion
        }

        public static string KayitSayisiMesajiGetir(int kayitSayisi)
        {
            return kayitSayisi == 0 ? KayitBulunamadiMesaji : kayitSayisi + " kayıt bulundu.";
        }
    }
}
