﻿using _28_1_DemoFilmlerClassLibrary.Data;
using _28_1_DemoFilmlerClassLibrary.Entities;
using _28_1_DemoFilmlerClassLibrary.Repositories;
using System.Globalization;

namespace _28_3_DemoFilmlerWindowsFormsApp
{
    public partial class FilmEkleForm : Form
    {
        FilmRepo filmRepo = new FilmRepo();
        YonetmenRepo yonetmenRepo = new YonetmenRepo();
        TurRepo turRepo = new TurRepo();

        public FilmEkleForm()
        {
            InitializeComponent();
        }

        private void FilmEkleForm_Load(object sender, EventArgs e)
        {
            nudYapimYili.Value = DateTime.Now.Year;
            dtpGosterimTarihi.Value = DateTime.Today;
            lMesaj.Text = "";
            FillYonetmenler();
            FillTurler();
        }

        void FillYonetmenler()
        {
            List<Yonetmen> yonetmenler = yonetmenRepo.YonetmenleriGetir().ToList();
			yonetmenler.Insert(0, new Yonetmen()
			{
				Id = -1,
				Adi = "-- Yönetmen Seçiniz --"
			});
			ddlYonetmen.DataSource = yonetmenler;
            ddlYonetmen.ValueMember = "Id";
            ddlYonetmen.DisplayMember = "AdiSoyadi";
        }

        void FillTurler()
        {
            List<Tur> turler = turRepo.TurleriGetir();
            lbTurler.DataSource = turler;
            lbTurler.ValueMember = "Id";
            lbTurler.DisplayMember = "Adi";
            lbTurler.ClearSelected();
        }

        private void bEkle_Click(object sender, EventArgs e)
        {
            Insert();
        }

        void Insert()
        {
            try
            {
                string adi = tbAdi.Text;
                if (string.IsNullOrWhiteSpace(adi))
                {
                    lMesaj.Text = "Ad girilmelidir!";
                    return;
                }

                short yapimYili = Convert.ToInt16(nudYapimYili.Value);

                decimal gisesi;
                if (!decimal.TryParse(tbGisesi.Text, NumberStyles.Any, new CultureInfo("tr-TR"), out gisesi))
                {
                    lMesaj.Text = "Gişe sayısal olmalıdır!";
                    return;
                }

                int yonetmenId = Convert.ToInt32(ddlYonetmen.SelectedValue);
                if (yonetmenId == -1)
                {
                    lMesaj.Text = "Yönetmen seçilmelidir!";
                    return;
                }

                if (lbTurler.SelectedItems.Count == 0)
                {
                    lMesaj.Text = "En az bir tür seçilmelidir!";
                    return;
                }
                List<int> turIdleri = new List<int>();
                Tur seciliTur;
                foreach (var selectedItem in lbTurler.SelectedItems)
                {
                    seciliTur = selectedItem as Tur;
                    turIdleri.Add(seciliTur.Id);
                }

                Film film = new Film()
                {
                    Adi = adi,
                    YapimYili = yapimYili,
                    Gisesi = gisesi,
                    Yonetmeni = yonetmenRepo.KayitGetir(yonetmenId) as Yonetmen,
                    Turleri = turRepo.TurleriGetir(turIdleri),
                    GosterimTarihi = dtpGosterimTarihi.Value,
                    Platform = rbSinema.Checked ? Platformlar.Sinema : rbNetflix.Checked ? Platformlar.Netflix : Platformlar.Amazon,
                    YerliMi = cbYerli.Checked
                };

                lMesaj.Text = filmRepo.FilmEkle(film);
            }
            catch
            {
                lMesaj.Text = Veriler.HataMesaji;
            }
        }

        private void bKapat_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
