using _28_1_DemoFilmlerClassLibrary.Data;
using _28_1_DemoFilmlerClassLibrary.Entities;
using _28_1_DemoFilmlerClassLibrary.Entities.Bases;
using _28_1_DemoFilmlerClassLibrary.Repositories;
using System.Globalization;

namespace _28_3_DemoFilmlerWindowsFormsApp
{
    public partial class Form1 : Form
    {
        FilmRepo filmRepo = new FilmRepo();

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            lKayitSayisi.Text = "";
            ddlIslem.SelectedIndex = 0;
            FillGrid();
        }

        void FillGrid()
        {
            dgvFilmler.DataSource = null;
            List<Film> filmler = filmRepo.FilmleriGetir().ToList();
            dgvFilmler.DataSource = filmler;
            SetColumnVisibilitesAndNames();
            lKayitSayisi.Text = Veriler.KayitSayisiMesajiGetir(filmler.Count);
        }

        void FillGrid(string adi)
        {
            dgvFilmler.DataSource = null;
            List<Film> filmler = filmRepo.FilmleriGetir(adi).ToList();
            dgvFilmler.DataSource = filmler;
            SetColumnVisibilitesAndNames();
            lKayitSayisi.Text = Veriler.KayitSayisiMesajiGetir(filmler.Count);
        }

        void SetColumnVisibilitesAndNames()
        {
            dgvFilmler.Columns["Adi"].HeaderText = "Ad";
            dgvFilmler.Columns["YapimYili"].HeaderText = "Yapm Yl";
            dgvFilmler.Columns["Gisesi"].HeaderText = "Giesi";
            dgvFilmler.Columns["Yonetmeni"].HeaderText = "Ynetmeni";
            dgvFilmler.Columns["Id"].HeaderText = "ID";
            dgvFilmler.Columns["GosterimTarihi"].HeaderText = "Gsterim Tarihi";

            dgvFilmler.Columns["YerliMi"].Visible = false;
            dgvFilmler.Columns["OlusturulmaTarihi"].Visible = false;
            dgvFilmler.Columns["Platform"].Visible = false;

            dgvFilmler.Columns["Adi"].Width = 200;
            dgvFilmler.Columns["YapimYili"].Width = 85;
            dgvFilmler.Columns["Gisesi"].Width = 90;
            dgvFilmler.Columns["Yonetmeni"].Width = 150;
            dgvFilmler.Columns["Id"].Width = 55;
            dgvFilmler.Columns["GosterimTarihi"].Width = 110;
        }

        private void bAdaGoreFilmleriListele_Click(object sender, EventArgs e)
        {
            ddlIslem.SelectedIndex = 0;
            string adi = tbAdi.Text.Trim();
            FillGrid(adi);
        }

        private void bIdyeGoreFilmiGoster_Click(object sender, EventArgs e)
        {
            ddlIslem.SelectedIndex = 0;
            int filmId;
            if (!int.TryParse(tbId.Text, out filmId))
            {
                MessageBox.Show("ID girilmelidir!");
                return;
            }
            Show(filmId);
        }

        void Show(int filmId)
        {
            Kayit kayit = filmRepo.KayitGetir(filmId);
            if (kayit == null)
            {
                MessageBox.Show(Veriler.KayitBulunamadiMesaji, "Uyar", MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                return;
            }
            Film film = (Film)kayit;
            string filmText, yonetmenText, turlerText;
            filmText = $"Film\r\n" +
                $"ID: {film.Id}\r\n" +
                $"Oluturulma Tarihi: {film.OlusturulmaTarihi.ToString("dd.MM.yyyy HH:mm:ss")}\r\n" +
                $"Ad: {film.Adi}\r\n" +
                $"Yapm Yl: {film.YapimYili}\r\n" +
                $"Giesi: {film.Gisesi.ToString("C2", new CultureInfo("tr-TR"))}\r\n" +
                $"Gsterim Tarihi: {film.GosterimTarihi.ToString("dd.MM.yyyy")}\r\n" +
                $"Platform: {film.Platform}\r\n" +
                $"Yerli / Yabanc: {(film.YerliMi ? "Yerli" : "Yabanc")}";
            yonetmenText = $"\r\nYnetmen\r\n" +
                $"Ad Soyad: {film.Yonetmeni.Adi} {film.Yonetmeni.Soyadi}\r\n" +
                $"Doum Tarihi: {film.Yonetmeni.DogumTarihi.ToString("dd.MM.yyyy")}\r\n" +
                $"Durumu: {(film.Yonetmeni.EmekliMi ? "Emekli" : "alyor")}";
            turlerText = "\r\nTrleri: ";
            foreach (Tur tur in film.Turleri)
            {
                turlerText += tur.Adi + ", ";
            }
            turlerText = turlerText.Substring(0, turlerText.Length - 2);
            MessageBox.Show(filmText + turlerText + yonetmenText, "Film Bilgisi", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
        }

        private void ddlIslem_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddlIslem.SelectedIndex == 1) // film ekle
            {
                ShowFilmEkleForm();
            }
            else if (ddlIslem.SelectedIndex == 2) // film dzenle
            {
                ShowFilmDuzenleForm();
            }
            else if (ddlIslem.SelectedIndex == 3) // film sil
            {
                ShowFilmSilForm();
            }
        }

        void ShowFilmEkleForm()
        {
            FilmEkleForm filmEkleForm = new FilmEkleForm();
            filmEkleForm.Show();
        }

        void ShowFilmDuzenleForm()
        {
            FilmDuzenleForm filmDuzenleForm = new FilmDuzenleForm();
            filmDuzenleForm.Show();
        }

        void ShowFilmSilForm()
        {
            FilmSilForm filmSilForm = new FilmSilForm();
            filmSilForm.Show();
        }

        private void listeleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ddlIslem.SelectedIndex = 0;
            FillGrid();
        }

        private void ekleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowFilmEkleForm();
        }

        private void dzenleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowFilmDuzenleForm();
        }

        private void silToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowFilmSilForm();
        }

        private void ynetmenlerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowYonetmenForm();
        }

        void ShowYonetmenForm()
        {
            Form form = new YonetmenForm();
            form.Show();
        }

        private void trlerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowTurForm();
        }

        void ShowTurForm()
        {
            Form form = new TurForm();
            form.Show();
        }
    }
}