﻿namespace _04_Constructors.Demos.OgrenciGercekProje
{
    public class Ogrenci
    {
        #region Fields (Constant)
        const decimal VIZE1CARPAN = 0.2m;
        const decimal VIZE2CARPAN = 0.2m;
        const decimal FINALCARPAN = 0.6m;
        #endregion



        #region Properties
        public string Adi { get; set; }
        public string Soyadi { get; set; }
        public decimal Vize1 { get; set; }
        public decimal Vize2 { get; set; }
        public decimal Final { get; set; }

        public Durumlar Durum => Ortalama >= 60 ? Durumlar.Geçti : Durumlar.Kaldı;
       
        public decimal Ortalama => VIZE1CARPAN * Vize1 + VIZE2CARPAN * Vize2 + FINALCARPAN * Final;
        #endregion



        #region Constructors
        public Ogrenci(string adi, string soyadi, decimal vize1, decimal vize2, decimal final)
        {
            Adi = adi;
            Soyadi = soyadi;
            Vize1 = vize1;
            Vize2 = vize2;
            Final = final;
        }

        public Ogrenci()
        {

        }
        #endregion
    }
}
