﻿namespace _04_Constructors.Demos.ZamanIslemleri
{
    /// <summary>
    /// Bu sınıfı kullanmak yerine TimeSpan kullanılmalı!
    /// </summary>
    public class TimeOperations
    {
        int _duration; // in seconds
        string _time; // Example: "21:03:56"

        public TimeOperations(int duration)
        {
            _duration = duration;
        }

        public TimeOperations(string time)
        {
            _time = time;
        }

        public string CalculateTime(bool includeHours = true) // in hours:minutes:seconds or minutes:seconds formats
        {
            int hours, minutes, seconds, hoursInSeconds, minutesInSeconds;
            if (includeHours)
            {
                hours = _duration / 60 / 60;
                hoursInSeconds = hours * 60 * 60;
                minutes = (_duration - hoursInSeconds) / 60;
                if (minutes >= 60)
                    minutes = (_duration - hoursInSeconds) % 60;
                minutesInSeconds = minutes * 60;
                seconds = _duration - hoursInSeconds - minutesInSeconds;
                return hours.ToString().PadLeft(2, '0') + ":" + minutes.ToString().PadLeft(2, '0') + ":" + seconds.ToString().PadLeft(2, '0');
            }
            else
            {
                minutes = _duration / 60;
                seconds = _duration % 60;
                return minutes.ToString().PadLeft(2, '0') + ":" + seconds.ToString().PadLeft(2, '0');
            }
        }

        public int CalculateDuration() // in seconds
        {
            int hours = Convert.ToInt32(_time.Split(':')[0]);
            int minutes = Convert.ToInt32(_time.Split(':')[1]);
            int seconds = Convert.ToInt32(_time.Split(':')[2]);
            return hours * (int)Math.Pow(60, 2) + minutes * 60 + seconds;
        }
    }
}
