﻿namespace _05_IDisposableAndFinalizers
{
    /// <summary>
    /// Kategori verilerini tutan model sınıfı.
    /// </summary>
    class Kategori
    {
        public int Id { get; set; } // veritabanı tablosu için birincil anahtar (primary key) Id özelliği

        public string Adi { get; set; } // Adi özelliği

        public string Aciklamasi { get; set; } // Aciklamasi özelliği



        public Kategori() // default constructor
        {
            Console.WriteLine("Kategori constructor'ı çalıştırıldı."); // log amaçlı
        }



        ~Kategori() // finalizer: yeni bir obje oluşturulurken constructor'daki kodlar çalıştığı gibi obje hafızadan temizlenirken de finalizer'daki kodlar çalışır,
                    // çoğunlukla class'larda finalizer yazılmaz,
                    // finalizer'lar Garbage Collector tarafından objenin hafızadan temizleme işlemi yapılırken çalıştırıldığından aşağıdaki konsola yazdırma
                    // sonucunu uygulama çalışırken hiç bir zaman görmeyeceğiz
        {
            // obje temizleme kodları buraya yazılır

            Console.WriteLine("Kategori finalizer'ı çalıştırıldı."); // log amaçlı
        }
    }
}
