﻿namespace _05_IDisposableAndFinalizers
{
    /// <summary>
    /// Ürün verilerini tutan model sınıfı.
    /// </summary>
    class Urun : IDisposable // Urun sınıfına IDisposable interface'ini implemente ediyoruz
                             // (ampüle tıklayıp veya klavyedeki Ctrl ve . tuşlarına basıp implement interface diyoruz).
                             // Bunun sonucunda interface içerisindeki Dispose method tanımının
                             // sınıf içerisinde implemente edilmesi (methodun oluşturularak kodlarının yazılması) gerekmektedir (interface'ler ileride anlatılacak).
    {
        public int Id { get; set; } // veritabanı tablosu için birincil anahtar (primary key) Id özelliği

        public string Adi { get; set; } // Adi özelliği

        public float BirimFiyati { get; set; } // BirimFiyati özelliği

        public short StokMiktari { get; set; } // StokMiktari özelliği



        public Urun(int id, string adi, float birimFiyati, short stokMiktari) // Urun tipindeki objeleri daha kolay new'leyebilmek için parametreli constructor oluşturduk (opsiyonel)
        {
            Id = id;
            Adi = adi;
            BirimFiyati = birimFiyati;
            StokMiktari = stokMiktari;
        }

        public Urun() // Urun tipindeki objeleri new'lerken özellikler üzerinden değer atamaları yapabilmek için de default constructor'ı oluşturduk (opsiyonel)
        {
            // default constructor içerisinde mutlaka kod yazılacak diye bir kural yoktur
        }



        #region Dispose İşlemi
        // .NET kütüphanesinde Heap Memory'de saklanan objeler Garbage Collector (çöp toplayıcı) tarafından otomatik olarak toplanıp uygun zamanda temizlenir.
        // Özellikle büyük veriler saklanacak sınıflara IDisposable interface'i implemente edilerek oluşturulan Dispose
        // methodu içerisinde büyük verilerin temizlenmesini sağlamak hafıza yönetimine katkıda bulunacaktır.
        // Dispose methodunu Garbage Collector'a bu obje ile işimizin bittiğini (çöpe attığımızı) belirttiğimiz method olarak düşünebiliriz.

        bool _disposed = false; // objenin dispose edilip edilmediğini belirten flag (bayrak)

        public void Dispose() // interface'i implemente ederek oluşturduğumuz method
        {
            if (!_disposed) // eğer obje daha önce dispose edilmediyse
            {
                _disposed = true; // objeyi dispose edildi olarak işaretle
                GC.SuppressFinalize(this); // Garbage Collector'a (GC) bu class'ın (this) finalizer'ını (ileride anlatılacak) çağırmamasını söyle
            }
        }
        #endregion
    }
}
