﻿using _04_StaticClassesAndMethods;

namespace _06_StaticClassesAndMethods
{
    internal class Program
    {
        // static class'lar new'lenmeden arka planda tek bir obje oluşturularak kullanılan class'lardır. Bu objeler tüm uygulama için paylaşılan kaynaklardır.
        // static bir class'ta tüm field (alan), property (özellik) ve behavior'lar (method) static olmalıdır.
        // static objeler uygulama çalıştığı sürece tek bir instance (obje) olarak saklanır.
        // Genelde bir uygulama ile ilgili konfigürasyon özellikleri veya uygulamanın pek çok class'ında ortak olan ve çok sık kullanılan methodlar static tanımlanmalıdır.
        // static objelere new'leme yapmadan direkt class adı üzerinden ulaşılarak içerisindeki static alan, özellik veya methodlar kullanılır.
        // Class static tanımlanmadan da içerisindeki bazı alan, özellik veya methodlar static tanımlanabilir ve direkt class adı üzerinden bunlar kullanılabilir,
        // class static olmadığı için de class new'lenerek içerisindeki static olmayan alan, özellik veya methodlar kullanılabilir.



        static void Main(string[] args)
        {
            Console.WriteLine("Title: " + Config.Title); // class static olduğu için içerisindeki Title özelliğine direkt class adı üzerinden ulaşabildik

            Config.ExecutedBy = "Çağıl Alsaç"; // tüm uygulama için ortak ExecutedBy özelliğine set işlemi yaptık dolayısıyla uygulamamızda ne zaman
                                               // bu özelliğe get ile ulaşırsak "Çağıl Alsaç" dönecek

            Console.WriteLine($"Executed By: {Config.ExecutedBy}"); // class static olduğu için içerisindeki ExecutedBy özelliğine direkt class adı üzerinden ulaşabildik

            Console.WriteLine($"Execution Date: {Config.ExecutionDate}"); // class static olduğu için içerisindeki ExecutionDate özelliğine direkt class adı üzerinden ulaşabildik



            Console.WriteLine();



            // static constructor ile class içerisindeki static ve static olmayan özellik ve methodlar örneği:
            // static özellik ve method kullanımları:
            Console.WriteLine($"Veritabanı adı: {Database.Name}"); // konsola Oracle yazacak
            Console.WriteLine($"Veritabanı dili: {Database.Language}"); // konsola PL/SQL yazacak

            Database.SetNameAndLanguage("Microsoft SQL Server", "T-SQL");
            Console.WriteLine($"Veritabanı adı: {Database.Name}"); // konsola Microsoft SQL Server yazacak
            Console.WriteLine($"Veritabanı dili: {Database.Language}"); // konsola T-SQL yazacak

            // static olmayan method kullanımları: önce Database tipinde bir obje initialize etmeliyiz
            Database database = new Database();
            Console.WriteLine($"Veritabanı adı: {Database.Name}"); // daha önce paylaşılan adını Microsoft SQL Server
                                                                   // yaptığımız için konsola Microsoft SQL Server yazacak
            Console.WriteLine($"Veritabanı dili: {Database.Language}"); // daha önce paylaşılan dilini T-SQL
                                                                        // yaptığımız için konsola T-SQL yazacak
            database.Log("select * from Filmler"); // Log methodu class'ta static olmadığı için obje üzerinden çağırıyoruz



            #region StringUtil
            string value1 = "Leo";
            string value2 = null;
            string value3 = "";
            string value4 = " ";
            string value5 = "   ";
            string value6 = " LUNA ";

            // nameof ile herhangi bir class'ın, field'ın, property'nin veya method'un adına ulaşılabilir, Empty: boş
            Console.WriteLine();
            Console.WriteLine(nameof(value1) + ":" + value1 + ":" + (StringUtil.IsEmpty(value1, true) ? "Empty" : "Not Empty")); // konsola Not Empty yazdırır
            Console.WriteLine(nameof(value2) + ":" + value2 + ":" + (StringUtil.IsEmpty(value2, true) ? "Empty" : "Not Empty")); // konsola Empty yazdırır
            Console.WriteLine(nameof(value3) + ":" + value3 + ":" + (StringUtil.IsEmpty(value3, true) ? "Empty" : "Not Empty")); // konsola Empty yazdırır
            Console.WriteLine(nameof(value4) + ":" + value4 + ":" + (StringUtil.IsEmpty(value4, true) ? "Empty" : "Not Empty")); // konsola Empty yazdırır
            Console.WriteLine(nameof(value4) + ":" + value4 + ":" + (StringUtil.IsEmpty(value4, false) ? "Empty" : "Not Empty")); // konsola Not Empty yazdırır
            Console.WriteLine(nameof(value5) + ":" + value5 + ":" + (StringUtil.IsEmpty(value5, true) ? "Empty" : "Not Empty")); // konsola Empty yazdırır
            Console.WriteLine(nameof(value5) + ":" + value5 + ":" + (StringUtil.IsEmpty(value5, false) ? "Empty" : "Not Empty")); // konsola Not Empty yazdırır
            Console.WriteLine(nameof(value6) + ":" + value6 + ":" + (StringUtil.IsEmpty(value6, true) ? "Empty" : "Not Empty")); // konsola Not Empty yazdırır
            Console.WriteLine(nameof(value6) + ":" + value6 + ":" + (StringUtil.IsEmpty(value6, false) ? "Empty" : "Not Empty")); // konsola Not Empty yazdırır

            // string tipinin IsNullOrWhiteSpace methodu üzerinden StringUtil sınıfının IsEmpty
            // method overload'ı kullanılarak string değerin null veya empty kontrolü:
            Console.WriteLine(nameof(value1) + ":" + value1 + ":" + (StringUtil.IsEmpty(value1) ? "Empty" : "Not Empty"));



            // double değerler
            double number1value, number2value, number3value, number4value, number5value, number6value; 

            // string değerler
            string number1 = "1";
            string number2 = "1,2";
            string number3 = "-34.56";
            string number4 = "123456,789";
            string number5 = "9.888.777,66";
            string number6 = "Number";

            Console.WriteLine();
            if (StringUtil.IsNumeric(number1, out number1value))
                Console.WriteLine(nameof(number1) + ":\"" + number1 + "\" (" + number1value + "):Numeric"); // konsola Numeric yazdırır
            else
                Console.WriteLine(nameof(number1) + ":\"" + number1 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number2, out number2value))
                Console.WriteLine(nameof(number2) + ":\"" + number2 + "\" (" + number2value + "):Numeric"); // konsola Numeric yazdırır
            else
                Console.WriteLine(nameof(number2) + ":\"" + number2 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number3, out number3value))
                Console.WriteLine(nameof(number3) + ":\"" + number3 + "\" (" + number3value + "):Numeric"); // konsola Numeric yazdırır ancak number3value output'u yanlış
            else
                Console.WriteLine(nameof(number3) + ":\"" + number3 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number3, out number3value, "en-US"))
                Console.WriteLine(nameof(number3) + ":\"" + number3 + "\" (" + number3value + "):Numeric"); // konsola Numeric yazdırır ve number3value output'u doğru
            else
                Console.WriteLine(nameof(number3) + ":\"" + number3 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number4, out number4value))
                Console.WriteLine(nameof(number4) + ":\"" + number4 + "\" (" + number4value + "):Numeric"); // konsola Numeric yazdırır
            else
                Console.WriteLine(nameof(number4) + ":\"" + number4 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number5, out number5value))
                Console.WriteLine(nameof(number5) + ":\"" + number5 + "\" (" + number5value + "):Numeric"); // konsola Numeric yazdırır
            else
                Console.WriteLine(nameof(number5) + ":\"" + number5 + "\":Not Numeric");

            if (StringUtil.IsNumeric(number6, out number6value))
                Console.WriteLine(nameof(number6) + ":\"" + number6 + "\" (" + number6value + "):Numeric"); // konsola Not Numeric yazdırır
            else
                Console.WriteLine(nameof(number6) + ":\"" + number6 + "\":Not Numeric");
            #endregion
        }
    }



    /// <summary>
    /// Uygulama ile ilgili ayarların bulunduğu konfigürasyon sınıfı.
    /// </summary>
    static class Config
    {
        /// <summary>
        /// Uygulamanın adı.
        /// </summary>
        //public static string Title = "Static Classes Demo"; // field (alan) public olarak kullanılmamalı
        public static string Title => "Static Classes Demo"; // alan yerine sadece getter'ı olan (readonly, sadece okunur değer atanamaz) bir property (özellik) üzerinden kullanılmalı

        /// <summary>
        /// Uygulamayı çalıştıran.
        /// </summary>
        public static string ExecutedBy { get; set; } // static field veya property'lere değere atama işlemi de (set) gerçekleştirilebilir

        /// <summary>
        /// Uygulamanın çalışma tarih ve saati.
        /// </summary>
        public static DateTime ExecutionDate => DateTime.Now; // static readonly property
    }



    /// <summary>
    /// Veritabanı paylaşılan ad ve dil genel bilgilerini tutan ve oluşturulan obje üzerinden
    /// SQL log'lamaları yapan sınıf.
    /// </summary>
    class Database
    {
        /// <summary>
        /// Veritabanı adı özelliği.
        /// </summary>
        public static string Name { get; set; } // hiç instance (obje) üretmeden ya da instance üreterek kullanılabilir

        /// <summary>
        /// Veritabanı dili özelliği.
        /// </summary>
        public static string Language { get; set; } // hiç instance (obje) üretmeden ya da instance üreterek kullanılabilir

        static Database() // Database class'ının default constructor'ı, static class'ların da constructor'ı yazılabilir,
                          // mutlaka çalışmasını istediğimiz kod bloğunu buraya yazıyoruz,
                          // default (varsayılan) olarak adı Oracle, dili de PL/SQL olacak
        {
            Name = "Oracle";
            Language = "PL/SQL";
        }

        /// <summary>
        /// İhtiyaç halinde veritabanı adı ve dili bu method çağrılarak güncellenebilir.
        /// </summary>
        /// <param name="name"></param>
        /// <param name="language"></param>
        public static void SetNameAndLanguage(string name, string language) // hiç instance (obje) üretmeden kullanılabilir
        {
            Name = name;
            Language = language;
        }

        /// <summary>
        /// SQL log'larını ekrana yazdırmak için method.
        /// </summary>
        /// <param name="sql"></param>
        public void Log(string sql) // sadece instance (obje) üretilerek kullanılabilir
        {
            Console.WriteLine($"\"{sql}\" logged.");
        }
    }
}