﻿namespace _08_InterfaceSegregation._1_Arac
{
    public class AracDemo
    {
        public static void Calistir()
        {
            Araba araba = new Araba() // araba referans değişkeni üzerinden Araba tipinde obje oluşturulması (initialization)
            {
                Marka = "Mini",
                Model = "Cooper S",
                TekerlekSayisi = 4,
                BeygirGucu = 184,
                KasaTipi = KasaTipiEnum.Hatchback,
                YakitTipi = YakitTipiEnum.Elektrik,
                DireksiyonSoldaMi = true,
                MotorHacmi = 1600
            };

            Motorsiklet motorsiklet = new Motorsiklet // motorsiklet referans değişkeni üzerinden Motorsiklet tipinde obje oluşturulması (initialization)
            {
                TekerlekSayisi = 2,
                YakitTipi = YakitTipiEnum.Benzin,
                MotorHacmi = 250,
                BeygirGucu = 70,
                Marka = "Yamaha",
                Model = "Racing Z70"
            };



            //IArac kamyon = new Kamyon(); // kamyon referans değişkeni üzerinden Kamyon tipinde obje oluşturulması (initialization)
            //kamyon.DireksiyonSoldaMi = true; // DireksiyonSoldaMi özelliğine IArac interface'i içinde olmadığından ulaşılamaz çünkü kamyon değişkeninin tipi IArac

            IArac kamyon = new Kamyon() // obje oluşturulurken Kamyon tipi üzerinden DireksiyonSoldaMi özelliğine ulaşılabilir
            {
                DireksiyonSoldaMi = true,
                Marka = "Mercedes",
                Model = "Axor",
                BeygirGucu = 200,
                YakitTipi = YakitTipiEnum.Dizel,
                TekerlekSayisi = 6,
                MotorHacmi = 3500
            };



            // konsola araç bilgilerini yazdırma
            Console.WriteLine("*** ARABA ***");
            Console.WriteLine(araba.AracBilgileriniGetir("\n")); // bir alt satırdan devam etmesi için satirSonu parametresi \n gönderildi

            Console.WriteLine("*** MOTORSİKLET ***");
            Console.WriteLine(motorsiklet.AracBilgileriniGetir("\n"));

            Console.WriteLine("*** KAMYON ***");
            Console.WriteLine(kamyon.AracBilgileriniGetir("\n"));
        }
    }
}
