﻿namespace _08_InterfaceSegregation._2_Fabrika.DogruKullanim
{
    public class DogruKullanimDemo
    {
        public static void Calistir()
        {
            Calisan calisan = new Calisan(); // Calisan tipindeki calisan referans değişkeni Calisan tipindeki objeyi refere ediyor

            calisan.YemekYe(); // konsola "Çalışan yemek yiyor." yazdırır

            calisan.Calis(); // konsola "Çalışan çalışıyor." yazdırır

            calisan.MaasAl(); // konsola "Çalışan maaş alıyor." yazdırır

            Console.WriteLine();



            Yonetici yonetici = new Yonetici(); // ICalisan yonetici = new Yonetici(); yazılmamalıdır çünkü o zaman sadece ICalisan
                                                // interface'indeki method tanımları, yani YemekYe ve MaasAl yonetici referans
                                                // değişkeni üzerinden çağrılabilir, Calis method tanımı çağrılamaz

            yonetici.YemekYe(); // konsola "Yönetici yemek yiyor." yazdırır

            yonetici.Calis(); // konsola "Yönetici çalışıyor." yazdırır

            yonetici.MaasAl(); // konsola "Yönetici maaş alıyor." yazdırır

            Console.WriteLine();



            ICalis robot = new Robot(); // Robot robot = new Robot(); da yazılabilir çünkü Robot class'ındaki method implementasyon
                                        // sayısı ile ICalis base interface'indeki method tanım sayısı aynı ve birbirlerine
                                        // karşılık geliyor

            robot.Calis(); // konsole "Robot çalışıyor." yazdırır,
                           // Interface Segregation prensibine uyup interface'leri parçaladığımız için artık robot
                           // referans değişkeni üzerinden sadece Calis methodunu çağırabiliyoruz
        }
    }



    /// <summary>
    /// Bir fabrikada çalışan insanlar için base interface.
    /// </summary>
    interface ICalisan
    {
        void YemekYe();
        void MaasAl();
    }

    /// <summary>
    /// Fabrikadaki hem insan hem de robotlar için sadece çalışma method tanımını içeren base interface.
    /// </summary>
    interface ICalis
    {
        void Calis();
    }

    class Calisan : ICalisan, ICalis // multiple interface implementation,
                                            // Calisan bir ICalisan'dır ve ICalis'ı da implemente eder şeklinde de okunabilir,
                                            // Calisan için ICalisan'daki tüm method tanımları ile ICalis'taki method tanımını
                                            // dolu bir şekilde implemente edebiliyoruz
    {
        public void Calis()
        {
            Console.WriteLine("Çalışan çalışıyor.");
        }

        public void MaasAl()
        {
            Console.WriteLine("Çalışan maaş alıyor.");
        }

        public void YemekYe()
        {
            Console.WriteLine("Çalışan yemek yiyor.");
        }
    }

    class Yonetici : ICalisan, ICalis // Yonetici bir ICalisan'dır ve ICalis'ı da implemente eder şeklinde de okunabilir,
                                             // Yonetici için ICalisan'daki tüm method tanımları ile ICalis'taki method tanımını
                                             // dolu bir şekilde implemente edebiliyoruz
    {
        public void Calis()
        {
            Console.WriteLine("Yönetici çalışıyor.");
        }

        public void MaasAl()
        {
            Console.WriteLine("Yönetici maaş alıyor.");
        }

        public void YemekYe()
        {
            Console.WriteLine("Yönetici yemek yiyor.");
        }
    }

    class Robot : ICalis // Robot sadece çalıştığı, yemek yemediği ve maaş almadığı için sadece ICalis interface'ini
                                // implemente ediyoruz, böylelikle tüm class'larda Interface Segregation prensibine uymuş olduk
    {
        public void Calis()
        {
            Console.WriteLine("Robot çalışıyor.");
        }
    }
}
