﻿namespace _11_AbstractClasses._1_ProductAndStore.Bases
{
    /// <summary>
    /// Veritabanında yönetilecek kayıtlar için kayıtların tüm ortak özelliklerini içeren soyut base class.
    /// </summary>
    abstract class RecordBase // abstract tanımladık çünkü RecordBase new'lenirse (ki soyut olduğu için new'lenemez)
                              // sadece Id ve Guid özellikleri kullanılabileceğinden obje bir anlam ifade etmez,
                              // dolayısıyla abstract tanımlayarak RecordBase'i kendinden miras alan sınıflar için
                              // Id ve Guid özellikleri üzerinden bir altyapı haline getirmiş olduk
    {
        public int Id { get; set; } // veritabanı tablolarında primary key olan özellik
        public string Guid { get; set; } // ilgili .NET sınıfı ve methodu üzerinden her zaman tekil olarak oluşturulacak
                                         // ve istenirse kaydın id'si gibi de kullanılabilecek metinsel özellik
    }
}
