﻿namespace _11_AbstractClasses._2_Dersler.Bases
{
    /// <summary>
    /// Kendisinden miras alacak YazilimDersi ve MuzikDersi sınıfları için ortak özellik ve methodları 
    /// içeren soyut (abstract) sınıf.
    /// </summary>
    abstract class DersBase
    {
        #region Properties
        /// <summary>
        /// Dersin kodu için kullanılacak tekil özellik.
        /// </summary>
        public int Id { get; set; }



        /// <summary>
        /// Dersin adı özelliği.
        /// </summary>
        public string Adi { get; set; }



        /// <summary>
        /// Dersin ilk sınavının notu özelliği.
        /// </summary>
        public double Sinav1Notu { get; set; }



        /// <summary>
        /// Dersin ikinci sınavının notu özelliği.
        /// </summary>
        public double Sinav2Notu { get; set; }
        #endregion



        #region Behaviors
        /// <summary>
        /// Id özelliği ile birlikte her miras alan sınıf için ön ek üzerinden ezilerek (override) 
        /// ders kodu dönen soyut (abstract) method tanımı.
        /// </summary>
        /// <returns>string</returns>
        public abstract string KodGetir();



        /// <summary>
        /// Her miras alan sınıf için varsayılan olarak 100 dönen ancak istenirse miras alan sınıfta ezilerek (override) 
        /// döneceği değer değiştirilebilen sanal (virtual) method.
        /// </summary>
        /// <returns>byte</returns>
        // 1. yöntem:
        //public virtual byte MaksimumNotGetir()
        //{
        //    return 100;
        //}
        // 2. yöntem:
        // Methodun mutlaka virtual olmasına gerek yoktur, tüm tek noktalı virgülle sonlanan kod bloğu içeren
        // method implementasyonlarında kullanılabilir.
        public virtual byte MaksimumNotGetir() => 100;



        /// <summary>
        /// İlk ve ikinci sınav notu özellikleri üzerinden ders notunu hesaplayan ve istenirse miras alan sınıfta 
        /// ezilerek (override) ders notu hesaplaması değişitirilebilen sanal (virtual) method. 
        /// 1. ve 2. sınav not ağırlıkları %50 üzerinden ders notunu hesaplayarak döner.
        /// </summary>
        /// <returns>double</returns>
        // 1. yöntem:
        //public virtual double DersNotuHesapla()
        //{
        //    return Sinav1Notu * 0.5 + Sinav2Notu * 0.5;
        //}
        // 2: yöntem:
        // Methodun mutlaka virtual olmasına gerek yoktur, tüm tek noktalı virgülle sonlanan kod bloğu içeren
        // method implementasyonlarında kullanılabilir.
        public virtual double DersNotuHesapla() => Sinav1Notu * 0.5 + Sinav2Notu * 0.5;
        #endregion
    }
}
