﻿namespace _12_InterfacesVsAbstractClasses._1_InterfaceOrnegi.Bases
{
    interface IOgrenciDosya // bu interface'i implemente edecek somut (concrete) sınıflar için ortak özellik ve method tanımlarını içeren soyut (abstract) interface
    {
        #region Özellik Tanımları
        string DosyaYolu { get; set; } // Dosyanın diskteki fiziksel yolu (absolute path) özellik tanımı.
        // *1 Özellikleri bu interface'i implemente eden tüm sınıflarda oluşturmak zorunda olduğumuzdan abstract bir base class oluşturup bu özelliği
        // içerisinde tanımlayarak kalıtım yoluyla alt sınıflara taşımak daha uygun olacaktır (Bakınız: 2_AbstractClassOrnegi -> Bases -> OgrenciDosyaBase -> *1).
        #endregion



        #region Method Tanımları
        string OgrencileriGetir(bool sayiEkle); // dosyadaki öğrencileri sayiEkle parametresine göre string olarak dönen method tanımı

        void OgrenciEkle(string ogrenci); // string olarak gönderilen öğrenci parametresini dosya sonuna ekleyen (append) method tanımı

        string DosyaAdiGetir(); // DosyaYolu özelliği üzerinden dosya adını dönen method tanımı.
        // *2 Bu method bu interface'i implemente eden tüm sınıflarda aynı şekilde implemente edileceğinden abstract bir base class oluşturup bu methodu
        // içerisinde implemente ederek kalıtım yoluyla alt sınıflara taşımak daha uygun olacaktır (Bakınız: 2_AbstractClassOrnegi -> Bases -> OgrenciDosyaBase -> *2). 

        string DosyaUzantisiGetir(); // DosyaYolu özelliği üzerinden dosya uzantısını dönen method tanımı.
        // *3 Bu method bu interface'i implemente eden tüm sınıflarda aynı şekilde implemente edileceğinden abstract bir base class oluşturup bu methodu
        // içerisinde implemente ederek kalıtım yoluyla alt sınıflara taşımak daha uygun olacaktır (Bakınız: 2_AbstractClassOrnegi -> Bases -> OgrenciDosyaBase -> *3). 
        #endregion
    }
}
