﻿namespace _12_InterfacesVsAbstractClasses._2_AbstractClassOrnegi.Bases
{
    abstract class OgrenciDosyaBase
    {
        #region Özellikler
        public string DosyaYolu { get; set; } // Dosyanın diskteki fiziksel yolu (absolute path) özellik tanımı.
        // *1 Kendisinden miras alan her sınıfta dosya yoluna ihtiyaç olacağından özelliği burada oluşturup alt sınıflara taşıyoruz.
        #endregion



        #region Methodlar
        /// <summary>
        /// Metin dosyası içeriğini sayiEkle parametresine göre string olarak dönen method tanımı.
        /// </summary>
        /// <param name="sayiEkle"></param>
        /// <returns>string</returns>
        public abstract string OgrencileriGetir(bool sayiEkle); // Dosyadaki öğrencileri sayiEkle parametresine göre string olarak dönen method tanımı.
        // Kendisinden miras alan her sınıfta farklı yöntemler üzerinden dosya okunacağından abstract (soyut) olarak tanımlıyoruz.
        // Bu şekilde interface'teki kullanıma benziyor.



        /// <summary>
        /// String olarak gönderilen ogrenci parametresini dosya sonuna ekleyen (append) method tanımı.
        /// </summary>
        /// <param name="ogrenci"></param>
        public abstract void OgrenciEkle(string ogrenci); // String olarak gönderilen öğrenci parametresini dosya sonuna ekleyen (append) method tanımı.
        // Kendisinden miras alan her sınıfta farklı yöntemler üzerinden dosyaya yazılacağından abstract (soyut) olarak tanımlıyoruz.
        // Bu şekilde interface'teki kullanıma benziyor.



        /// <summary>
        /// DosyaYolu özelliği üzerinden dosya adını dönen method.
        /// </summary>
        /// <returns>string</returns>
        public string DosyaAdiGetir() 
        // *2 Kendisinden miras alan her sınıfta aynı yöntemle dosya adı dönüleceğinden methodu burada implemente edip alt sınıflara taşıyoruz.
        {
            string dosya = Path.GetFileName(DosyaYolu); // Path sınıfının GetFileName methodu dosya adı ile birlikte uzantısını döner, örneğin Öğrenciler.txt

            return dosya.Split('.')[0]; // sadece dosya adını dönebilmek için . karakterine göre dosya'yı parçalayıp elde ettiğimiz dizideki ilk elemanı dönüyoruz, örneğin Öğrenciler
        }



        /// <summary>
        /// DosyaYolu özelliği üzerinden dosya uzantısını dönen method.
        /// </summary>
        /// <returns>string</returns>
        public string DosyaUzantisiGetir()
        // *3 Kendisinden miras alan her sınıfta aynı yöntemle dosya uzantısı dönüleceğinden methodu burada implemente edip alt sınıflara taşıyoruz.
        {
            string dosya = Path.GetExtension(DosyaYolu); // Path sınıfının GetExtension methodu dosya uzantısını döner, örneğin .txt

            return dosya.Substring(1).ToLower(); // sadece dosya uzantısını dönebilmek için dosya üzerinden 1. index'ten başlayıp sona kadar sub string alıyoruz
                                                 // ve tüm karakterleri küçük harfe dönüştürüyoruz, örneğin txt
        }
        #endregion
    }
}
