﻿using _18_ListCollectionType.Models;

namespace _18_ListCollectionType
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Collections (koleksiyonlar) dinamik array (dizi) objeleridir.
            // Dizilerin eleman sayıları sabitken koleksiyonların eleman sayıları eleman ekleme
            // ve çıkarma işlemlerine göre dinamik olarak değişir.
            // ArrayList, List, Dictionary ve Hashtable başlıca bazı koleksiyon tipleridir.
            // Queue (ilk eklenen ilk çıkar) ve Stack (ilk eklenen son çıkar) ise
            // ihtiyaca özel kullanılabilecek koleksiyon tiplerindendir.



            #region Type Safe (Generic) List Collection Type
            // type safe (tip güvenli) koleksiyonların içerisindeki eleman tipleri bellidir ve aynıdır,
            // genelde type safe collections kullanılır

            List<string> sehirler = new List<string>(); // <> içerisinde koleksiyon elemanlarının tipi belirlenir
                                                        // ve sadece bu tipte elemanlar koleksiyonda saklanabilir,
                                                        // önce içerisinde hiç bir eleman olmayan bir şehir listesi oluşturuyoruz,
                                                        // bu durumda sehirler'in Count yani eleman sayısı özelliği 0 olacaktır
            
            // daha sonra ArrayList'te olduğu gibi Add methodu ile listenin sonuna listenin eleman tipi üzerinden
            // istediğimiz kadar eleman ekliyoruz
            sehirler.Add("Ankara");
            sehirler.Add("İstanbul");
            sehirler.Add("İzmir");
            //sehirler.Add(6); // ArrayList'in aksine hata fırlatacaktır

            Console.WriteLine("Şehirler String Koleksiyonu:");

            // 3 elemanlı List<string> (List of string, yani string listesi, şeklinde de okunabilir) objesini konsola yazdırma
            foreach (var sehir in sehirler)
            {
                Console.WriteLine(sehir);
            }

            Console.WriteLine();

            // Array ve ArrayList'te olduğu gibi index üzerinden listenin istenilen elemanına ulaşılabilir
            Console.WriteLine(sehirler[1]); // konsola İstanbul yazdıracaktır

            Console.WriteLine();



            // içerisindeki eleman tipleri Sehir olan List (List of Sehir şeklinde de okunabilir)
            List<Sehir> sehirListesi = new List<Sehir>() // şehir listesini oluştururken elemanlarını dolduruyoruz
            {
                new Sehir(1, "Adana"), // istenirse parametreli constructor üzerinden yeni bir şehir objesi oluşturulabilir

                new Sehir() // istenirse default constructor kullanıldıktan sonra özellik atamaları üzerinden
                            // yeni bir şehir objesi oluşturulabilir
                {
                    PlakaNo = 7,
                    Adi = "Antalya"
                },

                new Sehir(26, "Eskişehir")
            };

            // eğer istenirse daha sonra listenin sonuna aşağıdaki farklı yöntemler üzerinden Sehir tipinde elemanlar eklenebilir
            // 1. yöntem: önce sehirElemani referans değişkeni üzerinden Sehir objesi oluşturuyoruz,
            // istenirse Sehir class'ının parametreli constructor'ı üzerinden de obje new'lenebilir
            Sehir sehirElemani = new Sehir()
            {
                PlakaNo = 9,
                Adi = "Aydın"
            };
            // daha sonra Add methoduna sehirElemani referans değişkenini parametre olarak göndererek sehirListesi'ne ekliyoruz
            sehirListesi.Add(sehirElemani);

            // 2. yöntem: oluşturduğumuz Sehir tipindeki objeyi parametre olarak Add methoduna göndererek sehirListesi'ne ekliyoruz,
            // istenirse Sehir class'ının parametreli constructor'ı üzerinden de obje new'lenebilir
            sehirListesi.Add(new Sehir()
            {
                PlakaNo = 16,
                Adi = "Bursa"
            });

            Console.WriteLine("Şehirler Obje Koleksiyonu:");

            // 5 elemanlı şehir listesini konsola yazdırma
            for (int i = 0; i < sehirListesi.Count; i++) // koleksiyon eleman sayısı için Count özelliği kullanılır
            {
                //Console.WriteLine(sehirListesi[i]); // Sehir class'ında Object class'ının ToString methodunu override
                                                      // etmediğimiz için sehirListesi'nin i. index'teki elemanı olan
                                                      // Sehir tipindeki objenin namespace'i ile birlikte tipini yazdırır
                                                      // (_17_ListCollectionType.Models.Sehir)
                // şehir bilgilerini yazdırmak için sehirListesi'ndeki Sehir tipindeki objenin property'lerini kullanmamız gerek,
                // veya Sehir class'ında ToString methodunu override ederek de obje bilgilerini yazdırabiliriz
                Console.WriteLine("Plaka: " + sehirListesi[i].PlakaNo + ", Ad: " + sehirListesi[i].Adi);
            }

            Console.WriteLine();

            // index üzerinden koleksiyondaki istediğimiz elemana ulaşabiliriz
            Sehir indexUzerindenSehir = sehirListesi[2];

            Console.WriteLine($"Plaka: {indexUzerindenSehir.PlakaNo}, Ad: {indexUzerindenSehir.Adi}");
            // konsola "Plaka: 26, Ad: Eskişehir" yazdıracaktır
            #endregion
        }
    }
}