﻿using System.Globalization;
using _18_CollectionMethods.Demos._3_Organizasyonlar.Models;

namespace _18_CollectionMethods.Demos._3_Organizasyonlar
{
    public class OrganizasyonlarDemo
    {
        #region I) Organizasyonlar Demo'yu Çalıştıran Method
        public void Calistir()
        {
            // local değişken tanımları
            string giris;
            int id;
            Organizasyon organizasyon;

            Console.WriteLine("\n*** Organizasyonlar Demo ***");
            Console.Write("Organizasyon işlemi seçiniz: (e: ekle, s: sil, y: yazdır, a: ara, ç: çıkış) ");
            giris = Console.ReadLine().ToLower().Trim(); // büyük küçük harf duyarlılığını (case sensitivity) ortadan kaldırmak için
                                                         // ToLower methodunu kullanıyoruz, ToUpper da kullanılabilir,
                                                         // kullanıcının başta veya sonda yanlışlıkla girdiği
                                                         // boşlukları temizlemek için de Trim kullanıyoruz

            while (giris != "ç") // giriş ç veya Ç olmadığı sürece döngü çalışacak
            {
                if (giris == "e") // giriş ekle ise
                {
                    organizasyon = KullaniciGirisi(); // kullanıcıdan organizasyon bilgilerini al
                    Ekle(organizasyon); // alınan organizasyonu organizasyonlara ekle
                    Console.WriteLine("Organizasyon ekleme işlemi başarıyla gerçekleştirildi.");
                }
                else if (giris == "s") // giriş sil ise
                {
                    Console.Write("Silmek istediğiniz organizasyonun ID'sini giriniz: ");
                    id = int.Parse(Console.ReadLine());
                    if (Sil(id)) // silme işlemi başarılı
                    {
                        Console.WriteLine("Organizasyon silme işlemi başarıyla gerçekleştirildi.");
                    }
                    else // silme başarısız
                    {
                        Console.WriteLine("Organizasyon silme işlemi gerçekleştirilemedi!");
                    }
                }
                else if (giris == "y") // giriş yazdır ise
                {
                    Yazdir();
                }
                else if (giris == "a") // giriş ara ise
                {
                    Console.Write("Aramak istediğiniz organizasyonun ID'sini giriniz: ");
                    id = int.Parse(Console.ReadLine());
                    organizasyon = Ara(id);
                    if (organizasyon is null) // if (organizasyon == null) da yazılabilir, organizasyon bulunamadı demektir
                    {
                        Console.WriteLine("Organizasyon bulunamadı!");
                    }
                    else // organizasyon bulundu demektir
                    {
                        Yazdir(organizasyon);
                    }
                }
                else // giriş başka ise
                {
                    Console.WriteLine("Geçersiz işlem!");
                }
                Console.Write("Organizasyon işlemi seçiniz: (e: ekle, s: sil, y: yazdır, a: ara, ç: çıkış) ");
                giris = Console.ReadLine().ToLower().Trim();
            }

            Console.WriteLine("Hoşçakalın.");
        }
        #endregion



        #region II) Organizasyonlar Demo Alanları
        // listedeki her bir organizasyon elemanının tekil bir id'si olması için tanımlayıp ilk değerine 1 atadığımız paylaşılan alan
        private static int _enSonOrganizasyonId = 1;

        // sınıf altında referans değişkenleri üzerinden objeler default constructor'ları kullanılarak new'lenebilir
        private List<Organizasyon> _organizasyonlar = new List<Organizasyon>();
        #endregion



        #region II) Organizasyonlar Demo Davranışları
        /// <summary>
        /// Kullanıcıdan organizasyon bilgilerini alan ve dönen method.
        /// </summary>
        /// <returns>Organizasyon</returns>
        private Organizasyon KullaniciGirisi()
        {
            Organizasyon organizasyon = new Organizasyon();
            Console.WriteLine($"{_enSonOrganizasyonId} ID'li Organizasyon Girişi:");
            organizasyon.Id = _enSonOrganizasyonId++; // en son _enSonOrganizasyonId değerini ata sonra _enSonOrganizasyonId değerini 1 arttır
            Console.Write("Adı: ");
            organizasyon.Adi = Console.ReadLine().Trim(); // kullanıcının başta veya sonda yanlışlıkla girdiği
                                                          // boşlukları temizlemek için Trim kullanıyoruz
            Console.Write("Düzenleyen: ");
            organizasyon.Duzenleyeni = Console.ReadLine().Trim();
            Console.Write("Başlangıç Tarihi (gün.ay.yıl saat:dakika): ");
            organizasyon.BaslangicTarihiVeSaati = DateTime.Parse(Console.ReadLine().Trim(), new CultureInfo("tr-TR"));
            Console.Write("Süresi: (saat:dakika) (maksimum 23:59) ");
            organizasyon.Suresi = TimeSpan.Parse(Console.ReadLine().Trim());
            return organizasyon;
        }

        /// <summary>
        /// Parametre olarak gönderilen organizasyonu konsola yazdıran overload edilmiş method.
        /// </summary>
        /// <param name="organizasyon"></param>
        private void Yazdir(Organizasyon organizasyon)
        {
            string sonuc = "";
            sonuc += $"{organizasyon.Id} ID'li Organizasyon:\n";
            sonuc += $"Adı: {organizasyon.Adi}\n";
            sonuc += $"Düzenleyen: {organizasyon.Duzenleyeni}\n";
            sonuc += $"Başlangıç Tarihi: {organizasyon.BaslangicTarihiVeSaati.ToString("dd.MM.yyyy HH:mm")}\n";
            sonuc += $"Bitis Tarihi: {organizasyon.BitisTarihiVeSaati.ToString("dd.MM.yyyy HH:mm")}\n";
            sonuc += $"Süresi (saat:dakika): {organizasyon.Suresi.ToString(@"hh\:mm")}\n";
            sonuc += $"Toplam Süresi (dakika): {organizasyon.Suresi.TotalMinutes}";
            Console.WriteLine(sonuc);
        }

        /// <summary>
        /// Organizasyon koleksiyonundaki elemanları ve eleman sayısını konsola yazdıran overload edilmiş method.
        /// </summary>
        private void Yazdir()
        {
            foreach (Organizasyon organizasyon in _organizasyonlar)
            {
                Yazdir(organizasyon);
            }
            Console.WriteLine("Toplam " + _organizasyonlar.Count + " adet organizasyon bulundu.");
        }

        /// <summary>
        /// Parametre olarak gönderilen id'ye göre _organizasyonlar koleksiyonunda arama yapan method.
        /// Eğer organizasyon bulunursa organizasyonu, bulunamazsa null döner.
        /// </summary>
        /// <param name="id"></param>
        /// <returns>Organizasyon</returns>
        private Organizasyon Ara(int id)
        {
            Organizasyon bulunanOrganizasyon = null; // İlk olarak organizasyonu bulamadığımızı varsayıyoruz.
            foreach (Organizasyon organizasyon in _organizasyonlar) // _organizasyonlar koleksiyonundaki her bir organizasyon için:
            {
                if (organizasyon.Id == id) // Eğer organizasyonun Id'si parametre olarak gelen id'ye eşitse organizasyonu bulduk demektir.
                {
                    bulunanOrganizasyon = organizasyon; // Döngü turundaki organizasyonu bulunanOrganizasyon'a atıyoruz.
                    break; // Organizasyonu bulduğumuz için _organizasyonlar koleksiyonundaki diğer elemanlara bakmamıza gerek yok,
                           // döngüyü kırıyoruz.
                }
            }
            return bulunanOrganizasyon; // Eğer _organizasyonlar koleksiyonunda bulduysak organizasyonu, bulamadıysak null dönüyoruz.
        }

        /// <summary>
        /// Parametre olarak gönderilen organizasyonu _organizasyonlar koleksiyonuna ekleyen method.
        /// </summary>
        /// <param name="organizasyon"></param>
        private void Ekle(Organizasyon organizasyon)
        {
            _organizasyonlar.Add(organizasyon);
        }

        /// <summary>
        /// Parametre olarak gönderilen id'ye göre organizasyonu _organizasyonlar koleksiyonundan çıkaran method.
        /// Eğer silme işlemi başarılı olursa true, başarısız olursa false döner.
        /// </summary>
        /// <param name="id"></param>
        /// <returns>bool</returns>
        private bool Sil(int id)
        {
            Organizasyon organizasyon = Ara(id); // Önce organizasyonu id'ye göre arıyoruz.
            if (organizasyon is null) // if (organizasyon == null) da yazılabilir.
                return false; // Organizasyonu bulamadığımız için silme işlemi sonucu olarak false dönüp methodu sonlandırıyoruz.
            // Eğer if koşulu sağlanmazsa organizasyonu bulduk demektir, aşağıdaki satırdan devam ediyoruz.
            _organizasyonlar.Remove(organizasyon); // Organizasyonu _organizasyonlar koleksiyonundan çıkarmak için
                                                   // parametre olarak Remove methoduna gönderiyoruz. 
                                                   // Remove methodu koleksiyondan çıkarma işlemi eleman bulunup gerçekleşirse true,
                                                   // eleman bulunamayıp gerçekleşemezse false döner.
            return true; // Silme işlemi başarılı olduğu için sonucu true dönüp methodu sonlandırıyoruz.
        }
        #endregion
    }
}
