﻿using System.Globalization;

namespace _20_DictionaryCollectionType
{
    public class Ulke
    {
        #region Properties
        public string Adi { get; set; }

        /// <summary>
        /// Kişi sayısı.
        /// </summary>
        public int Nufusu { get; set; }

        /// <summary>
        /// Kilometrekare.
        /// </summary>
        public double Yuzolcumu { get; set; }
        #endregion



        #region Constructors
        public Ulke() // default (parametresiz) constructor
        {

        }

        public Ulke(string adi, int nufusu, double yuzolcumu) // parametreli constructor
        {
            Adi = adi;
            Nufusu = nufusu;
            Yuzolcumu = yuzolcumu;
        }
        #endregion



        #region Behaviors (Object Sınıfındaki ToString Methodunun Ülke Bilgilerini String Olarak Dönmek İçin Ezilmesi)
        public override string ToString()
        {
            // istenirse CultureInfo objesi bir kere new'lenip aşağıda gereken yerlerde kullanılabilir
            CultureInfo cultureInfo = new CultureInfo("tr-TR"); // Türkiye kültür (bölge) ayarı

            string ulke = "Ülke Bilgisi:\n";
            ulke += "Adı: " + Adi + "\n";

            ulke += "Nüfusu: " + string.Format(cultureInfo, "{0:N0}", Nufusu) + " kişi\n";
            // string sınıfının Format methodu üzerinden sırasıyla kültür (bölge) ayarı, virgülle birlikte toplam haneleri sağa hizalanmamış (padding left) ve
            // ondalık hanesi olmayan sayı formatı ({0:N0}) ile sayı (Nufusu) parametreleri kullanılarak formatlama yapılabilir

            ulke += "Yüzölçümü: " + Yuzolcumu.ToString("N1", cultureInfo) + " kilometrekare";
            // herhangi bir sayısal tipteki değişken, alan, özellik veya method üzerinden ki burada Yuzolcumu özelliği, ToString methodu üzerinden sırasıyla
            // tek ondalık haneli sayı formatı (N1) ile kültür (bölge) ayarı kullanılarak formatlama yapılabilir

            return ulke;
        }
        #endregion
    }
}
