﻿using _22_DependencyInjection.Logging.Repositories;

namespace _22_DependencyInjection.Logging
{
    public class LoggingDemo
    {
        public void Calistir()
        {
            #region 1) Constructor Injection
            // Genellikle kullanılan Dependency Injection yöntemidir.
            // Soyut olarak tanımlanan new'lenmiş bir objenin başka bir sınıfın constructor'ına 
            // parametre olarak gönderilmesi üzerinden gerçekleştirilir.

            #region I. Yöntem:
            /*
            ILogger logger = new FileLogger(); // ILogger tipinde bir değişken üzerinden FileLogger tipinde bir obje oluşturuyoruz,
                                               // eğer uygulamamızın veritabanına loglama yapmasını istiyorsak sadece bu satırı
                                               // ILogger logger = new DatabaseLogger();
                                               // olarak değiştirmememiz yeterli, dolayısıyla uygulamanın loglama işlemlerini
                                               // tek bir satırdaki tek bir değişiklik üzerinden yönetebiliyoruz

            ProductRepo productRepo = new ProductRepo(logger); // objeyi ProductRepo constructor'ına gönderiyoruz
                                                               // yani enjekte ediyoruz
            */
            #endregion

            #region II. Yöntem:
            ProductRepo productRepo = new ProductRepo(new FileLogger()); // ProductRepo sınıfına FileLogger objesi
                                                                         // new'lenerek parametre olarak gönderilebilir
            #endregion

            productRepo.Add(); // hem ürün eklendi mesajı hem de yukarıda eğer FileLogger tipinde obje enjekte edildiyse
                               // dosya loglama yapıldı mesajı, DatabaseLogger tipinde obje enjekte edildiyse
                               // veritabanı loglama yapıldı mesajı konsola yazdırılacak

            productRepo.Delete(); // hem ürün silindi mesajı hem de yukarıda eğer FileLogger tipinde obje enjekte edildiyse
                                  // dosya loglama yapıldı mesajı, DatabaseLogger tipinde obje enjekte edildiyse
                                  // veritabanı loglama yapıldı mesajı konsola yazdırılacak

            #endregion



            #region 2) Property Injection
            // Soyut olarak tanımlanan new'lenmiş bir objenin başka bir sınıfın new'lenmesi sırasında
            // sınıfın soyut olarak tanımlanan özelliğine atanması üzerinden gerçekleştirilir.

            #region I. Yöntem:
            /*
            ILogger logger = new DatabaseLogger(); // ILogger tipinde bir değişken üzerinden DatabaseLogger tipinde bir
                                                   // obje oluşturuyoruz, eğer uygulamamızın dosyaya loglama
                                                   // yapmasını istiyorsak sadece bu satırı
                                                   // ILogger logger = new FileLogger();
                                                   // olarak değiştirmememiz yeterli, dolayısıyla uygulamanın loglama işlemlerini
                                                   // tek bir satırdaki tek bir değişiklik üzerinden yönetebiliyoruz

            CategoryRepo categoryRepo = new CategoryRepo() // CategoryRepo tipindeki objeyi new'lerken sınıfın
                                                           // ILogger tipindeki özelliğine DatabaseLogger tipindeki
                                                           // objenin ILogger tipindeki referansını atıyoruz
                                                           // ve uygulamamızın veritabanında loglama işlemleri
                                                           // yapmasını sağlıyoruz
            {
                Logger = logger 
            };
            */
            #endregion

            #region II. Yöntem:
            CategoryRepo categoryRepo = new CategoryRepo()
            {
                Logger = new DatabaseLogger() // Logger özelliğine DatabaseLogger veya FileLogger objesi new'lenerek atanabilir
            };
            #endregion

            categoryRepo.Update();

            #endregion



            #region 3) Method Injection
            // Soyut olarak tanımlanan new'lenmiş bir objenin başka bir sınıfın methoduna parametre olarak
            // gönderilmesi üzerinden gerçekleştirilir.

            StoreRepo storeRepo = new StoreRepo(); // StoreRepo tipindeki objeyi new'liyoruz

            #region I. Yöntem:
            /*
            ILogger logger = new FileLogger(); // ILogger tipinde bir değişken üzerinden FileLogger tipinde bir
                                               // obje oluşturuyoruz, eğer uygulamamızın veritabanına loglama
                                               // yapmasını istiyorsak sadece bu satırı
                                               // ILogger logger = new DatabaseLogger();
                                               // olarak değiştirmememiz yeterli, dolayısıyla uygulamanın loglama işlemlerini
                                               // tek bir satırdaki tek bir değişiklik üzerinden yönetebiliyoruz

            // FileLogger olarak new'lenmiş ILogger tipindeki referans değişkenini içerisinde loglama işlemi yapmak
            // istediğimiz methodlara parametre olarak göndererek enjekte ediyoruz
            storeRepo.GetList(logger);
            storeRepo.GetDetails(logger);
            */
            #endregion

            #region II. Yöntem:
            // ILogger tipindeki parametre DatabaseLogger veya FileLogger new'lenmiş objesi olarak gönderilebilir,
            // bu da Constructor ve Property Injection'dan farklı olarak farklı methodlara ihtiyaca göre farklı
            // objeler enjekte etmemizi sağlar, oysa ki Constructor ve Property Injection üzerinden sadece tek tipte
            // bir obje enjekte edilebilir
            storeRepo.GetList(new DatabaseLogger());
            storeRepo.GetList(new FileLogger());
            #endregion

            #endregion
        }
    }
}
