﻿using _22_DependencyInjection.Demos;
using _22_DependencyInjection.Logging;

namespace _22_DependencyInjection
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Dependency Injection sınıflar veya modüller arası bağımlılıkları minimize etmek ve yönetmek için kullanılır.
            // Örneğin Dependency Injection kullanılarak bir yazılım projesinde loglama mekanizması kolaylıkla
            // veritabanı veya dosya loglama şekilnde değiştirilebilir.
            // Genel amaç herhangi bir sınıfta değişiklik yapmadan o sınıftaki obje üzerinden
            // değişiklikleri yönetebilmektir.
            // Dependency Injection genellikle soyut yapılar yani abstract class'lar veya interface'ler üzerinden uygulanır.

            // Veri tutan ve veri yönetilebilien sınıflar için Entity, Model veya DTO (Data Transfer Object) kavramları kullanılır,
            // veri yönetilen sınıflar için Repository (Repo) kavramı kullanılırken service veya manager kavramları
            // iş yapan sınıflar için kullanılır.
            // Model'ler Service'lerde, Entity ve DTO'lar ise Repository'lerde kullanılır.
            // Aşağıdaki örnekte ProductRepo ürün ekleme ve silme işlerini, CategoryRepo kategori güncelleme işini
            // ve StoreRepo ise mağaza listeleme ve detay getirme işlerini yapan repository sınıflarıdır.

            // Tight Coupling (Sıkı Bağlılık): Eğer bir sınıfta (örneğin A sınıfı) başka somut (concrete) bir sınıf
            // üzerinden (örneğin B sınıfı) obje new'lenerek kullanılıyorsa bu iki yapı birbirine sıkı bağlıdır,
            // çünkü A sınıfında B sınıfı ile ilgili değişiklik yapmak için B sınıfında değişiklik yapmak gerekir
            // ve ihtiyaç durumunda B sınıfının eski halini kullanmak için yine B sınıfında değişiklikler yapmak gerekecektir.

            // Loose Coupling (Gevşek Bağlılık): Eğer bir sınıfta (örneğin A sınıfı) başka soyut (abstract) bir sınıf veya interface
            // üzerinden (örneğin B sınıfı veya interface'i) obje new'lenerek kullanılıyorsa veya sınıfa enjekte ediliyorsa
            // bu iki yapı birbirine gevşek bağlıdır, çünkü soyut base sınıftan miras alan veya interface'i implemente eden
            // başka somut (concrete) sınıflar (örneğin C ve D sınıfları) base B tipindeki referans değişkeni üzerinden
            // ihtiyaca göre C veya D tipinde new'lenerek veya sınıfa base B tipi üzerinden new'lenip enjekte edilerek
            // C ve D sınıflarında hiçbir değişiklik yapılmadan uygulamanın davranışı C veya D'ye göre kolayca değiştirilebilir.
            // Genelde Dependency Injection kullanılarak uygulanan Loose Coupling'de enjekte edilecek objenin neler yapabileceğine
            // ihtiyacımız olduğundan soyut yapılar (abstract class veya interface) kullanırız, dolayısıyla 
            // bu soyut base sınıflardan miras alan veya interface'leri implemente eden yeni somut sınıflar oluşturarak
            // oluşturulan somut sınıflar üzerinden uygulamanın davranışlarını kolayca değiştirip yönetebiliriz.



            #region Logging (Constructor, Property and Method Injections)
            LoggingDemo loggingDemo = new LoggingDemo();
            loggingDemo.Calistir();
            #endregion



            #region Araba ve Sürücü Demo
            ArabaVeSurucuDemo arabaVeSurucuDemo = new ArabaVeSurucuDemo();
            arabaVeSurucuDemo.Calistir();
            #endregion
        }
    }
}