﻿namespace _23_ValueAndReferenceTypes.ReferenceTypes
{
    public class ReferenceTypesDemo1
    {
        public void Calistir()
        {
            string[] sehirler1 = { "Ankara", "Adana, Antalya" }; // atama referans üzerinden gerçekleşir,
                                                                 // sehirler1 içerisinde Ankara, Adana ve Antalya elemanları olan diziyi refere eder,
                                                                 // örneğin sehirler1'in dizi için tuttuğu adres A1B1 olsun

            string[] sehirler2 = { "Bursa", "Bolu", "Balıkesir" }; // örneğin sehirler2'nin dizi için tuttuğu adres C2D2 olsun

            Console.WriteLine($"1) Şehirler 1'in 0 index'indeki elemanı: {sehirler1[0]}, Şehirler 2'nin 0 index'indeki elemanı: {sehirler2[0]}");
            // konsola "1) Şehirler 1'in 0 index'indeki elemanı: Ankara, Şehirler 2'nin 0 index'indeki elemanı: Bursa" yazdırır

            sehirler2 = sehirler1; // atama referans üzerinden gerçekleşir yani C2D2 olan sehirler2'nin adresi A1B1 olur

            Console.WriteLine($"2) Şehirler 1'in 0 index'indeki elemanı: {sehirler1[0]}, Şehirler 2'nin 0 index'indeki elemanı: {sehirler2[0]}");
            // konsola "2) Şehirler 1'in 0 index'indeki elemanı: Ankara, Şehirler 2'nin 0 index'indeki elemanı: Ankara" yazdırır

            sehirler1[0] = "İstanbul"; // hem sehirler2 hem de sehirler1 referans değişkenleri A1B1 adresi üzerinden içinde Ankara, Adana ve Antalya
                                       // elemanlarını tutan diziyi refere ettiğinden, sehirler1'in 0 index'indeki elemanının İstanbul atanması sonucu dizinin
                                       // ilk elemanı İstanbul olarak güncellenir ve hem sehirler1[0] hem de sehirler2[0] aynı dizideki İstanbul elemanına ulaşır

            Console.WriteLine($"3) Şehirler 1'in 0 index'indeki elemanı: {sehirler1[0]}, Şehirler 2'nin 0 index'indeki elemanı: {sehirler2[0]}");
            // konsola "3) Şehirler 1'in 0 index'indeki elemanı: İstanbul, Şehirler 2'nin 0 index'indeki elemanı: İstanbul" yazdırır
        }
    }
}
