﻿namespace _23_ValueAndReferenceTypes.ReferenceTypes
{
    /// <summary>
    /// Değer tiplerin referanslarının methodlarda kullanımı
    /// </summary>
    public class ReferenceTypesDemo4
    {
        public void Calistir()
        {
            int sayi1 = 10;
            int sayi2 = 5;

            int carpim = 0; // ref kullanarak değişkeni methoda parametre olarak göndereceğimizden ilk değer ataması yapmalıyız

            int toplam = ToplaVeCarp(sayi1, sayi2, ref carpim); // carpim referansı method içerisinde çarpım sonucu olarak güncellenecek
                                                                // ve biz de bu sonucu aşağıda yazdırabileceğiz,
                                                                // dolayısıyla method hem toplama hem de çarpma sonuçlarını döndürmektedir

            Console.WriteLine($"{sayi1} + {sayi2} = {toplam}, {sayi1} * {sayi2} = {carpim}");
            // konsola "10 + 5 = 15, 10 * 5 = 50" yazdırır

            int bolum; // out kullanarak değişkeni methoda parametre olarak göndereceğiz, ilk değer ataması yapmamıza gerek yoktur

            int fark = CikarVeBol(sayi1, sayi2, out bolum); // bolum referansı method içerisinde bölüm sonucu olarak güncellenecek
                                                            // ve biz de bu sonucu aşağıda yazdırabileceğiz,
                                                            // dolayısıyla method hem çıkarma hem de bölme sonuçlarını döndürmektedir

            Console.WriteLine($"{sayi1} - {sayi2} = {fark}, {sayi1} / {sayi2} = {bolum}");
            // konsola "10 - 5 = 5, 10 / 5 = 2" yazdırır
        }



        int ToplaVeCarp(int sayi1, int sayi2, ref int carpim)
        {
            carpim = sayi1 * sayi2; // ref ile carpim parametresinin değerini değil adresini kullan dediğimizden
                                    // çarpma işlemi sonucu carpim'in refere ettiği adrese atanır
                                    // ve sonuç hem bu method içerisinde geçerlidir, hem de method dışına yansır,
                                    // ref kullanımı için method çağrılmadan önce aynı tipte değişken tanımlanıp
                                    // ilk değer ataması yapılmalıdır ve method çağrılırken değişken başında
                                    // ref yazılarak parametre olarak gönderilmelidir

            return sayi1 + sayi2; // toplam sonucunu da methoddan dönüyoruz
        }

        int CikarVeBol(int sayi1, int sayi2, out int bolum)
        {
            bolum = sayi1 / sayi2; // out ile bolum parametresinin değerini değil adresini kullan dediğimizden
                                   // bölme işlemi sonucu bolum'un refere ettiği adrese atanır
                                   // ve sonuç hem bu method içerisinde geçerlidir, hem de method dışına yansır,
                                   // out kullanımı için method çağrılmadan önce aynı tipte değişken tanımlanması
                                   // yeterlidir, ilk değer ataması yapılmasına gerek yoktur ve method çağrılırken
                                   // değişken başında out yazılarak parametre olarak gönderilmelidir

            return sayi1 - sayi2; // çıkarma sonucunu da methoddan dönüyoruz
        }
    }
}
