﻿using _27_DemoKopeklerimConsoleApp.Data;
using _27_DemoKopeklerimConsoleApp.Entities;
using _27_DemoKopeklerimConsoleApp.Entities.Bases;
using _27_DemoKopeklerimConsoleApp.Repositories.Bases;

namespace _27_DemoKopeklerimConsoleApp.Repositories
{
    public class KopekRepo : IRepo
    {
        private IrkRepo _irkRepo = new IrkRepo();

        public List<Kopek> KopekleriGetir()
        {
            return Veriler.Kopekler;
        }

        public List<Kopek> KopekleriGetir(string adi)
        {
            List<Kopek> kopekler = new List<Kopek>();
            List<Kopek> mevcutKopekler = KopekleriGetir();
            foreach (Kopek mevcutKopek in mevcutKopekler)
            {
                if (!string.IsNullOrWhiteSpace(adi) && mevcutKopek.Adi.Contains(adi, StringComparison.OrdinalIgnoreCase))
                {
                    kopekler.Add(mevcutKopek);
                }
            }
            return kopekler;
        }

        private Kopek KopekGetir(string adi, int id = 0)
        {
            Kopek kopek = null;
            List<Kopek> mevcutKopekler = KopekleriGetir();
            foreach (Kopek mevcutKopek in mevcutKopekler)
            {
                if (id == 0 && mevcutKopek.Adi.Equals(adi, StringComparison.OrdinalIgnoreCase))
                {
                    kopek = mevcutKopek;
                    break;
                }
                else if (id != mevcutKopek.Id && mevcutKopek.Adi.Equals(adi, StringComparison.OrdinalIgnoreCase))
                {
                    kopek = mevcutKopek;
                    break;
                }
            }
            return kopek;
        }

        public Kayit KayitGetir(int id)
        {
            Kayit kayit = null;
            List<Kopek> kopekler = KopekleriGetir();
            foreach (Kopek kopek in kopekler)
            {
                if (kopek.Id == id)
                {
                    kayit = kopek;
                    break;
                }
            }
            return kayit;
        }

        public string KopekEkle(string adi, DateTime dogumTarihi, bool erkekMi, int irkId, double boyu, double kilosu)
        {
            if (KopekGetir(adi) is not null)
                return "Girilen ada sahip köpek bulunmaktadır!";
            Kayit irk = _irkRepo.KayitGetir(irkId);
            if (irk is null)
                return Veriler.KayitBulunamadiMesaji;
            Kopek kopek = new Kopek()
            {
                Id = Veriler.EnSonId++,
                Adi = adi.Trim(),
                DogumTarihi = dogumTarihi,
                ErkekMi = erkekMi,
                Irki = irk as Irk,
                Boyu = boyu,
                Kilosu = kilosu
            };
            Veriler.Kopekler.Add(kopek);
            return "Köpek başarıyla eklendi.";
        }

        public string KopekEkle(Kopek kopek)
        {
            if (KopekGetir(kopek.Adi) is not null)
                return "Girilen ada sahip köpek bulunmaktadır!";
            kopek.Id = Veriler.EnSonId++;
            Veriler.Kopekler.Add(kopek);
            return "Köpek başarıyla eklendi.";
        }

        public string KopekGuncelle(int id, string adi, DateTime dogumTarihi, bool erkekMi, int irkId, double boyu, double kilosu)
        {
            if (KopekGetir(adi, id) is not null)
                return "Girilen ada sahip köpek bulunmaktadır!";
            Kayit irk = _irkRepo.KayitGetir(irkId);
            if (irk is null)
                return Veriler.KayitBulunamadiMesaji;
            Kayit mevcutKopekKaydi = KayitGetir(id);
            if (mevcutKopekKaydi is null)
                return Veriler.KayitBulunamadiMesaji;
            Kopek mevcutKopek = (Kopek)mevcutKopekKaydi;
            mevcutKopek.Adi = adi.Trim();
            mevcutKopek.DogumTarihi = dogumTarihi;
            mevcutKopek.ErkekMi = erkekMi;
            mevcutKopek.Irki = (Irk)irk;
            mevcutKopek.Boyu = boyu;
            mevcutKopek.Kilosu = kilosu;
            return "Köpek başarıyla güncellendi.";
        }

        public string KopekGuncelle(Kopek kopek)
        {
            if (KopekGetir(kopek.Adi, kopek.Id) is not null)
                return "Girilen ada sahip köpek bulunmaktadır!";
            Kopek mevcutKopek = KayitGetir(kopek.Id) as Kopek;
            if (mevcutKopek is null)
                return Veriler.KayitBulunamadiMesaji;
            mevcutKopek.Adi = kopek.Adi.Trim();
            mevcutKopek.DogumTarihi = kopek.DogumTarihi;
            mevcutKopek.ErkekMi = kopek.ErkekMi;
            mevcutKopek.Irki = kopek.Irki;
            mevcutKopek.Boyu = kopek.Boyu;
            mevcutKopek.Kilosu = kopek.Kilosu;
            return "Köpek başarıyla güncellendi.";
        }

        public string KopekSil(int id)
        {
            Kopek mevcutKopek = KayitGetir(id) as Kopek;
            if (mevcutKopek is null)
                return Veriler.KayitBulunamadiMesaji;
            Veriler.Kopekler.Remove(mevcutKopek);
            return "Köpek başarıyla silindi.";
        }
    }
}
