﻿using _28_1_DemoFilmlerClassLibrary.Data;
using _28_1_DemoFilmlerClassLibrary.Entities;
using _28_1_DemoFilmlerClassLibrary.Entities.Bases;
using _28_1_DemoFilmlerClassLibrary.Repositories.Bases;

namespace _28_1_DemoFilmlerClassLibrary.Repositories
{
    public class FilmRepo : IRepo
    {
        public List<Film> FilmleriGetir()
        {
            return Veriler.Filmler;
        }

        public List<Film> FilmleriGetir(string adi)
        {
            List<Film> filmler = new List<Film>();
            List<Film> mevcutFilmler = FilmleriGetir();
            foreach (Film mevcutFilm in mevcutFilmler)
            {
                if (!string.IsNullOrWhiteSpace(adi) && mevcutFilm.Adi.Contains(adi, StringComparison.OrdinalIgnoreCase))
                    filmler.Add(mevcutFilm);
            }
            return filmler;
        }

        public Kayit KayitGetir(int id)
        {
            Film film = null;
            List<Film> mevcutFilmler = FilmleriGetir();
            foreach (Film mevcutFilm in mevcutFilmler)
            {
                if (mevcutFilm.Id == id)
                {
                    film = mevcutFilm;
                    break;
                }
            }
            return film;
        }

        private Film FilmGetir(string adi, int id = 0) // id 0: yeni film ekleme, diğer: film güncelleme
        {
            Film film = null;
            List<Film> mevcutFilmler = FilmleriGetir();
            foreach (Film mevcutFilm in mevcutFilmler)
            {
                if (id == 0 && mevcutFilm.Adi.Equals(adi, StringComparison.OrdinalIgnoreCase)) // yeni film ekleme
                {
                    film = mevcutFilm;
                    break;
                }
                else if (mevcutFilm.Id != id && mevcutFilm.Adi.Equals(adi, StringComparison.OrdinalIgnoreCase)) // film güncelleme
                {
                    film = mevcutFilm;
                    break;
                }
            }
            return film;
        }

        public string FilmEkle(Film film)
        {
            if (film.Turleri is null || film.Turleri.Count == 0)
                return "Filmin türleri girilmemiştir!";
            Film mevcutFilm = FilmGetir(film.Adi);
            if (mevcutFilm is not null)
                return "Girilen ada sahip film bulunmaktadır!";
            film.Id = Veriler.EnSonId++;
            Veriler.Filmler.Add(film);
            return "Film başarıyla eklendi.";
        }

        public string FilmGuncelle(Film film)
        {
            if (film.Turleri is null || film.Turleri.Count == 0)
                return "Filmin türleri girilmemiştir!";
            if (FilmGetir(film.Adi, film.Id) is not null)
                return "Girilen ada sahip film bulunmaktadır!";
            Kayit mevcutKayit = KayitGetir(film.Id);
            if (mevcutKayit is null)
                return Veriler.KayitBulunamadiMesaji;
            Film mevcutFilm = mevcutKayit as Film;
            mevcutFilm.Adi = film.Adi;
            mevcutFilm.YapimYili = film.YapimYili;
            mevcutFilm.Gisesi = film.Gisesi;
            mevcutFilm.Yonetmeni = film.Yonetmeni;
            mevcutFilm.Turleri = film.Turleri;
            mevcutFilm.GosterimTarihi = film.GosterimTarihi;
            mevcutFilm.Platform = film.Platform;
            mevcutFilm.YerliMi = film.YerliMi;
            return "Film başarıyla güncellendi.";
        }

        public string FilmSil(int id)
        {
            Kayit mevcutFilm = KayitGetir(id);
            if (mevcutFilm is null)
                return Veriler.KayitBulunamadiMesaji;
            Veriler.Filmler.Remove((Film)mevcutFilm);
            return "Film başarıyla silindi.";
        }
    }
}
