﻿using _28_1_DemoFilmlerClassLibrary.Data;
using _28_1_DemoFilmlerClassLibrary.Entities;
using _28_1_DemoFilmlerClassLibrary.Repositories;
using System.Globalization;

namespace _28_3_DemoFilmlerWindowsFormsApp
{
    public partial class FilmSilForm : Form
    {
        FilmRepo filmRepo = new FilmRepo();

        public FilmSilForm()
        {
            InitializeComponent();
        }

        private void FilmSilForm_Load(object sender, EventArgs e)
        {
            lMesaj.Text = "";
        }

        private void bGoster_Click(object sender, EventArgs e)
        {
            int filmId;
            if (!int.TryParse(tbId.Text, out filmId))
            {
                lMesaj.Text = "ID sayısal olmalıdır!";
                return;
            }

            Show(filmId);
        }

        void Show(int filmId)
        {
            Film film = filmRepo.KayitGetir(filmId) as Film;
            if (film == null)
            {
                lMesaj.Text = Veriler.KayitBulunamadiMesaji;
                return;
            }

            string filmText, yonetmenText, turlerText;
            filmText = $"Film\r\n" +
                $"ID: {film.Id}\r\n" +
                $"Oluşturulma Tarihi: {film.OlusturulmaTarihi.ToString("dd.MM.yyyy HH:mm:ss")}\r\n" +
                $"Adı: {film.Adi}\r\n" +
                $"Yapım Yılı: {film.YapimYili}\r\n" +
                $"Gişesi: {film.Gisesi.ToString("C2", new CultureInfo("tr-TR"))}\r\n" +
                $"Gösterim Tarihi: {film.GosterimTarihi.ToString("dd.MM.yyyy")}\r\n" +
                $"Platform: {film.Platform}\r\n" +
                $"Yerli / Yabancı: {(film.YerliMi ? "Yerli" : "Yabancı")}";
            yonetmenText = $"\r\nYönetmen\r\n" +
                $"Adı Soyadı: {film.Yonetmeni.Adi} {film.Yonetmeni.Soyadi}\r\n" +
                $"Doğum Tarihi: {film.Yonetmeni.DogumTarihi.ToString("dd.MM.yyyy")}\r\n" +
                $"Durumu: {(film.Yonetmeni.EmekliMi ? "Emekli" : "Çalışıyor")}";
            turlerText = "\r\nTürleri: ";
            foreach (Tur tur in film.Turleri)
            {
                turlerText += tur.Adi + ", ";
            }
            turlerText = turlerText.Substring(0, turlerText.Length - 2);

            rtbFilm.Text = filmText + turlerText + yonetmenText;
        }

        private void bSil_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Filmi silmek istediğinize emin misiniz?", "Soru", MessageBoxButtons.YesNo,
                MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
            {
                int filmId;
                if (!int.TryParse(tbId.Text, out filmId))
                {
                    lMesaj.Text = "ID sayısal olmalıdır!";
                    return;
                }

                Delete(filmId);
            }
        }

        void Delete(int filmId)
        {
            try
            {
                lMesaj.Text = filmRepo.FilmSil(filmId);
            }
            catch
            {
                lMesaj.Text = Veriler.HataMesaji;
            }
        }

        private void bKapat_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
